function GIAS_v2
% Object nearest neighbour analysis
% GUI to control the extraction of bubble/vesicle/object data
% from basaltic rocks, geological images, 2D spatial coordinates
% Adapted from Fourier-Mellin Transform GUI by Adam Wilmer (aiw99r@ecs.soton.ac.uk)
% Tabbed environment from Shiying Zhao (zhao@arch.umsl.edu)
% 
%
% Version: 2.1
% Created: 25-11-2011
% Last Updated: 11-03-2012

% Authors: Ciaran Beggan (British Geological Survey, UK) and
%          Chris Hamilton (Goddard Space Flight Center, USA)
%
% Version 0.1: Counts the bubbles in an image, outputs the c, r and skew
%               vs. kurtosis and area histograms
%
% Version 0.2: Creating a GUI interface as designed by Chris Hamilton to
%              incorporate many of the Image processing features for
%              bubbles
%
% Version 0.3: Pre-release version - updated to call gias_guifun_v02.m
% Version 0.31: Pre-release version - Removed Sliders
% 
% Version 0.4: Release for Computers and Geosciences. The Logistic test has
%              been removed.
% Version 1.1: Released onto the GeoAnalysis webpage
% Version 1.11: Can input the size of the area you are interested in. For
%               Chris Hamilton's request for large datasets.
%
% Version 2.0: Adding a new tab to calculate data from planetary bodies.
% Version 2.01: Completed the updates to the Skew vs. kurtosis curves, the
%               error envelopes for Poisson, Scavanged k = 1 and 2. Plus a
%               number of updates for the Planetary Tab
% Version 2.02: Add in a search for the radius and flattening parameters of
%               solar system bodies.
%
% Version 2.1: Improvements to the interface. RELEASE TO GEOANALYSIS.ORG
 
clear all
close all
global colo
addpath(genpath('.'))


colo=[0.7 0.9 0.7];
colortab = [0.4314,0.5882,0.8431];
screensize = get(0,'Screensize');

% ------------- the MAIN figure window ----------------------
h0 = figure('Units','normalized', ...
    'Color',colo, ...
    'Menubar','none',...
    'Toolbar','none',...
    'CreateFcn','gias_guifun_v06 create;', ...
    'Name','Geological Image Analysis Software', ...
    'NumberTitle','off', ...
    'PaperOrientation','landscape', ...
    'PaperType','a4letter', ...
    'Position',[0.08 0.08 0.85 0.85], ...
    'Tag','Fig1');


%Input Panel
% % %% % %% % %% % %% % %
InputPanel(h0, colo)



% % TAB PANEL ____-------_______-------______------

uitabpanel(...
    'Parent',h0,...
    'TitlePosition','lefttop',...
    'Position',[0,0,1,0.7],...
    'Margins',{[0,1,1,0],'pixels'},...
    'Title',{'Image Analysis','Nearest Neighbor Analysis', 'Planetary NN'},...
    'CreateFcn',@CreateTab,...
    'ResizeFcn', @TabResize1, ...
    'BackgroundColor', 'w', ...
    'SelectedItem',2,...
    'Tag', 'TabPanel');

    function CreateTab(htab,evdt,hpanel,hstatus)  % #ok
        

        % %%%%%%%   TAB 1
        % static text boxes for displaying registration information ----------------------

        Tab_ImageAnalysis(htab,evdt,hpanel,hstatus, colortab, colo)


        % %%%%%%%   TAB 2
        % static text boxes for displaying registration information ----------------------

        Tab_NearestNeighbor(htab,evdt,hpanel,hstatus, colortab, colo)

        % %%%%%%%   TAB 3
        % Planetary NN analysis
        % ----------------------
        Tab_PlanetaryNN(htab,evdt,hpanel,hstatus, colortab, colo)



    end

    function TabResize1(hobj,evdt) % #ok<INUSD>
        figpos = get(h0,'Position');
        tabpos = get(htab,'Position');
        tabpos(4) = figpos(4);
        set(hobj,'Position',tabpos);

        width = tabpos(3)/figpos(3);
    end

end