function [data] = BubbleProcess_v02(data)

% Function to produce the plots for the Bubble nearest neighbour analysis GUI

% Author: Ciaran Beggan
% Created: 13-03-2008
% Last Modified: 23-05-2009

% Version 0.1: Initial script to process image, produce histogram and
% derive the C, R and Skew vs Kurtosis statistics
%
% Veriosn 0.2: Adding in features to produce data for bubble orientation
%              versus size, eccentricity etc
%              Also added in the feature for pixel list or pixel image only
%              Added a check in the NNlonlylist option to see if there are
%              any repeated centroids
%
% Version 0.21: The user can now manually specify the area of the hull


if data.NNonlyimage
    sem_bubbles = data.input1(:,:,1);
    [i, j] = find(sem_bubbles );
    centroid_list_for_NN_processing = [i, j];
    data.centroid = centroid_list_for_NN_processing;
    data.allpoints = data.centroid; % For the output file
    
    % Axes6 Plot: Nearest Neighbour Histogram
    % Remove points on the convex hull
    [data.k, data.chull_area] = convhull(data.centroid(:,1), data.centroid(:,2));
    if data.CheckInputHullArea          % The user can manually enter the Hull area here
        data.chull_area = data.InputHullArea;
    end
    intpoints = data.centroid;
    intpoints(data.k,:) = [];
    data.NN = length(intpoints);
    sqdistances = squareform(pdist([intpoints(:,1) intpoints(:,2)])) + diag(ones(data.NN,1)*999);
    data.distances = min(sqdistances);
    
    data.NNoid = zeros(size(data.distances));
    % A rather lazy way to find the positions of the NN object ID
    for i = 1:length(data.distances)
        pos = find(data.distances(i) == sqdistances(:,i));
        data.NNoid(i) = pos(1);
    end
    data.centroid = intpoints;

    data = PlotPoissonNNHist_v01(data);

    data = WriteOutNNStatistics(data);
    
    data = PlotNNRandCgraphs(data);
    
    data = PlotNNSkewvsKurtosis(data);

else
    sem_bubbles = data.input1(:,:,1);
    if data.invertimage
        if islogical(sem_bubbles)
            sem_bubbles = double(~sem_bubbles)*255;
        else
            temp = double(sem_bubbles) - 128;
            temp2 = -temp;
            sem_bubbles = temp2 + 127;
        end
    end
    area_threshold = data.IgnoreSmallArea;                % Remove bubbles smaller than this area

    sem_bw = (sem_bubbles >= data.SetThresholdLevelLower & sem_bubbles <= data.SetThresholdLevelUpper);
    
    %set(gcbf,'CurrentAxes',findobj(gcbf,'Tag','Axes1'));
    %cla reset
    %imshow(sem_bw, 'Parent', gca,'InitialMagnification',100)
    %axis image; box on;  colormap(gray), drawnow, pause(0.001)
    %set(gca,'Tag','Axes1');
    %set(gcbf,'Userdata',data);
    
%     if data.invertimage
%         set(gcbf,'CurrentAxes',findobj(gcbf,'Tag','Axes1'));    % move to the correct axes
%         cla reset
%         mx = sem_bw;
%         cla; %imagesc(mx);   % display image
%         imshow(mx, 'InitialMagnification',100)
%         axis off;   % turns off labelling
%         axis image
%         colormap gray
%         set(gca,'Tag','Axes1');
%         set(gcbf,'Userdata',data);
%     end
    
    L = bwlabel(sem_bw);
    bubdata = regionprops(L, 'Area', 'Centroid', 'Perimeter','Eccentricity', 'Orientation', 'EquivDiameter', 'PixelList');

    data.areas = cat(1,bubdata.Area);
    data.perimeters = cat(1,bubdata.Perimeter);
    data.equiv_diameters = cat(1,bubdata.EquivDiameter);
    data.orientations = cat(1, bubdata.Orientation);
    data.eccentricity = cat(1, bubdata.Eccentricity);
    data.centroid = cat(1,bubdata.Centroid);
    
    im_size = size(data.input1);
    data.percentvesicle = (sum(data.areas)/(im_size(1)*im_size(2)))*100;

    % Remove the bubbles smaller or larger than required
    if data.IgnoreSmallArea > 0
        min_bubbles = data.areas < area_threshold;
        if ~strcmp(data.IgnoreLargeArea,'Max');
            max_bubbles = data.areas > data.IgnoreLargeArea;
            exclude = min_bubbles | max_bubbles;
        else
            exclude = min_bubbles;
        end
        % Centroids
        centroids = data.centroid(:); centroids(repmat(exclude,2,1))  = [];
        data.centroid = reshape(centroids, length(centroids)/2, 2);
        data.allpoints = data.centroid; % For the output file
        % Areas
        areas = data.areas; areas(exclude) = []; data.areas = areas;
        % Perimeter
        perimeters = data.perimeters; perimeters(exclude) = [];
        data.perimeters = perimeters;
        % Orientations
        orientations = data.orientations; orientations(exclude) = [];
        data.orientations = orientations;
        % Eccentricity
        eccentricity = data.eccentricity; eccentricity(exclude) = [];
        data.eccentricity = eccentricity;
        % Equiv_diameters
        equiv_diameters = data.equiv_diameters; equiv_diameters(exclude) = [];
        data.equiv_diameters = equiv_diameters;
    end

    if data.IgnoreBoundaryBubbles
        % Remove bubbles that touch the side
        im_size = size(sem_bubbles);
        edge = data.IgnoreSmallArea;
        touching = [];
        row = find(~exclude);
        for i = 1:length(data.centroid)
            list = bubdata(row(i)).PixelList;
            if any(( list(:,1) < edge ) | (list(:,2) < edge) | (list(:,2) > (im_size(1) - edge)) | (list(:,1) > (im_size(2) - edge)))
                touching = [touching; i]; %#ok
            end
        end
        
        exclude = touching;
        % Centroids
        centroids = data.centroid; centroids(exclude,:) =[];
        data.centroid = centroids;
        data.allpoints = data.centroid; % For the output file
        % Areas
        areas = data.areas; areas(exclude) = []; data.areas = areas;
        % Perimeter
        perimeters = data.perimeters; perimeters(exclude) = [];
        data.perimeters = perimeters;
        % Orientations
        orientations = data.orientations; orientations(exclude) = [];
        data.orientations = orientations;
        % Eccentricity
        eccentricity = data.eccentricity; eccentricity(exclude) = [];
        data.eccentricity = eccentricity;
        % Equiv_diameters
        equiv_diameters = data.equiv_diameters; equiv_diameters(exclude) = [];
        data.equiv_diameters = equiv_diameters;   
          
        
        if isempty(data.areas)
            
           set(findobj(gcbf,'Tag','Pushbutton1'),'String',' No Data >> '); 
            pause(2)
            set(findobj(gcbf,'Tag','Pushbutton1'),'String',' Process >>'); 
            return
       end             % If there is no data (i.e. it has all been excluded, then return to the starting line
    
    end
    
    

    
    
    % Tab 1 - Size-freq Distributions
    % % -----------------------------
    % Axes2 Plot: Bubble Size Frequency Histogram
    data = PlotBubbleSizeFrequencyHist_v01(data);

    % Axes 3: Bubble Perimeters
    data = PlotBubblePerimeters(data);

    % Axes 4: Bubble Eccentricity
    data = PlotBubbleEccentricity(data);

    % Axes 5: Bubble Orientations
    data = PlotBubbleOrientations(data);

    % Summary Statistics
    data = WriteOutSummaryStatistic(data);


    % Tab 2: Nearest Neightbour Plots
    % % -----------------------------

    % Axes6 Plot: Nearest Neighbour Histogram
    % Remove points on the convex hull
    %data.centroid = centroid_list_for_NN_processing;
    [data.k, data.chull_area] = convhull(data.centroid(:,1), data.centroid(:,2));
    if data.CheckInputHullArea          % The user can manually enter the Hull area here
        data.chull_area = data.InputHullArea;
    end
    intpoints = data.centroid;
    intpoints(data.k,:) = [];
    data.NN = length(intpoints);
    sqdistances = squareform(pdist([intpoints(:,1) intpoints(:,2)])) + diag(ones(data.NN,1)*999);
    data.distances = min(sqdistances);
    
    data.NNoid = zeros(size(data.distances));
    % A rather lazy way to find the positions of the NN object ID
    for i = 1:length(data.distances)
        pos = find(data.distances(i) == sqdistances(:,i));
        data.NNoid(i) = pos(1);
    end

    data.centroid = intpoints;
    data = PlotPoissonNNHist_v01(data);

    data = WriteOutNNStatistics(data);
    
    data = PlotNNRandCgraphs(data);
    
    data = PlotNNSkewvsKurtosis(data);
    

end
set(gcbf,'Userdata',data)
