function [output_statsPNN, output_statsNPNN, output_statsK1NN, output_statsK2NN, output_statsL] = CalculatePNSLstats(data)

%
%
% Version 0.2: Removed Logistic fit -
stat = data.distances*data.PixelSize;
ra = mean(stat);
data.NN = length(stat);
rho_0 = data.NN/(data.chull_area*data.PixelSize^2);

% % % %
% Store for Poisson NN
NNbias_flat_k_0 = dlmread('skdata/NNbias_flat_k_0.dat');
store =  NNbias_flat_k_0(:, [4, 5, 2, 3, 1]);

% Calculate R and C

re = 1/(2* sqrt(rho_0));  output_statsPNN.re = re;
sde = 0.26136/( sqrt(data.NN*rho_0));  output_statsPNN.sde = sde;
c = (ra - re)/sde;   output_statsPNN.c = c;
r = ra/re;           output_statsPNN.r = r;

% Interpolate to find an approximate limit

output_statsPNN.cthreshneg1 = interp1([store(:,5); 10001], [store(:,1)-1*store(:,2); -2],data.NN,'linear');
output_statsPNN.cthreshneg2 = interp1([store(:,5); 10001], [store(:,1)-2*store(:,2); -2],data.NN,'linear');
output_statsPNN.cthreshpos1 = interp1([store(:,5); 10001], [store(:,1)+1*store(:,2); 2],data.NN,'linear');
output_statsPNN.cthreshpos2 = interp1([store(:,5); 10001], [store(:,1)+2*store(:,2); 2],data.NN,'linear');

output_statsPNN.rthreshneg1 = interp1([store(:,5); 10001], [store(:,3)-1*store(:,4); 1],data.NN,'linear');
output_statsPNN.rthreshneg2 = interp1([store(:,5); 10001], [store(:,3)-2*store(:,4); 1],data.NN,'linear');
output_statsPNN.rthreshpos1 = interp1([store(:,5); 10001], [store(:,3)+1*store(:,4); 1],data.NN,'linear');
output_statsPNN.rthreshpos2 = interp1([store(:,5); 10001], [store(:,3)+2*store(:,4); 1],data.NN,'linear');

% Ideal values of R and C
output_statsPNN.idealc = interp1([store(:,5); 10001], [store(:,1); 0],data.NN,'linear');
output_statsPNN.idealr = interp1([store(:,5); 10001], [store(:,3); 1],data.NN,'linear');

if  (data.r < data.rthreshneg2)
    output_statsPNN.ImplicationR  = 'Clustered (R < -2std)';
elseif (data.r > data.rthreshneg2) &&  (data.r < data.rthreshneg1)
    output_statsPNN.ImplicationR  = 'Random (-2std < R < -1std)';
elseif (data.r > data.rthreshneg1) &&  (data.r < data.rthreshpos1)
    output_statsPNN.ImplicationR  = 'Random (-1std < R < +1std)';
elseif (data.r > data.rthreshpos1) &&  (data.r < data.rthreshpos2)
    output_statsPNN.ImplicationR  = 'Random (+1std < R < +2std)';
elseif (data.r > data.rthreshpos2)
    output_statsPNN.ImplicationR  = 'Uniform (R > +2td)';
else
    output_statsPNN.ImplicationR  =  'Unknown outcome';
end

if (data.r > data.rthreshneg2) &&  (data.r < data.rthreshpos2)
    if  (data.c < data.cthreshneg2)
        output_statsPNN.ImplicationC  = 'Not Significant (c < -2std)';
    elseif (data.c > data.cthreshneg2) &&  (data.c < data.cthreshneg1)
        output_statsPNN.ImplicationC  = 'Significant (-2std < c < -1std)';
    elseif (data.c > data.cthreshneg1) &&  (data.c < data.cthreshpos1)
        output_statsPNN.ImplicationC  = 'Significant (-1std < c < +1std)';
    elseif (data.c > data.cthreshpos1) &&  (data.c < data.cthreshpos2)
        output_statsPNN.ImplicationC  = 'Significant (+1std < c < +2std)';
    elseif (data.c > data.cthreshpos2)
        output_statsPNN.ImplicationC  = 'Not significant (c > +2std)';
    end
else
    output_statsPNN.ImplicationC  = 'Not applicable';
end


% % % %
% 'NormPoisson'

store =  [0.98611       1.3148        1.163      0.21733     10; ...
    0.88368       1.1746       1.0843       0.1121           30; ...
    0.88167        1.167       1.0652     0.086268           50; ...
    0.85576       1.0832       1.0447     0.05662           100; ...
    0.81891       1.0696       1.0303     0.039533          200; ...
    0.78469       1.0659       1.0237     0.032471          300; ...
    0.77288       1.0543       1.0204     0.024647          500; ...
    0.7641        1.0401       1.0126     0.017193          1000];


% Calculate R and C

min_rpnn = data.SetNormPoissonThresholdLevel*data.PixelSize;

new_distances = stat(stat>min_rpnn);
data.nNN = length(new_distances);

if isempty(new_distances)
    
    output_statsNPNN.c = 0; output_statsNPNN.r = 0;
    output_statsNPNN.sde = 0;
    output_statsNPNN.re = 0;
    
    output_statsNPNN.cthreshneg1 = 0; output_statsNPNN.cthreshneg2 = 0;
    output_statsNPNN.cthreshpos1 = 0; output_statsNPNN.cthreshpos2 = 0;
    
    output_statsNPNN.rthreshneg1 = 0; output_statsNPNN.rthreshneg2 = 0;
    output_statsNPNN.rthreshpos1 = 0; output_statsNPNN.rthreshpos2 = 0;
    
    % Ideal values of R and C
    output_statsNPNN.idealc = 0;  output_statsNPNN.idealr = 0;
    
else
    
    re =  (sum((new_distances.^2).*exp(-pi*rho_0*new_distances.^2)))/sum((new_distances).*exp(-pi*rho_0*new_distances.^2));
    
    vare = (sum((new_distances.^3).*exp(-pi*rho_0*new_distances.^2)))/sum((new_distances).*exp(-pi*rho_0*new_distances.^2));
    
    sde =  sqrt(vare)/sqrt(data.NN);
    
    output_statsNPNN.re = re;
    c = (ra - re)/sde;
    output_statsNPNN.c = c;
    output_statsNPNN.sde = sde;
    r = ra/re; output_statsNPNN.r = r;
    
    
    output_statsNPNN.cthreshneg1 = interp1([store(:,5); 10001], [store(:,1)-1*store(:,2); -2],data.nNN,'linear');
    output_statsNPNN.cthreshneg2 = interp1([store(:,5); 10001], [store(:,1)-2*store(:,2); -2],data.nNN,'linear');
    output_statsNPNN.cthreshpos1 = interp1([store(:,5); 10001], [store(:,1)+1*store(:,2); 2],data.nNN,'linear');
    output_statsNPNN.cthreshpos2 = interp1([store(:,5); 10001], [store(:,1)+2*store(:,2); 2],data.nNN,'linear');
    
    output_statsNPNN.rthreshneg1 = interp1([store(:,5); 10001], [store(:,3)-1*store(:,4); 1],data.nNN,'linear');
    output_statsNPNN.rthreshneg2 = interp1([store(:,5); 10001], [store(:,3)-2*store(:,4); 1],data.nNN,'linear');
    output_statsNPNN.rthreshpos1 = interp1([store(:,5); 10001], [store(:,3)+1*store(:,4); 1],data.nNN,'linear');
    output_statsNPNN.rthreshpos2 = interp1([store(:,5); 10001], [store(:,3)+2*store(:,4); 1],data.nNN,'linear');
    
    % Ideal values of R and C
    output_statsNPNN.idealc = interp1([store(:,5); 10001], [store(:,1); 0],data.nNN,'linear');
    output_statsNPNN.idealr = interp1([store(:,5); 10001], [store(:,3); 1],data.nNN,'linear');
    
    if  (data.r < data.rthreshneg2)
        output_statsNPNN.ImplicationR  = 'Clustered (R < -2std)';
    elseif (data.r > data.rthreshneg2) &&  (data.r < data.rthreshneg1)
        output_statsNPNN.ImplicationR  = 'Random (-2std < R < -1std)';
    elseif (data.r > data.rthreshneg1) &&  (data.r < data.rthreshpos1)
        output_statsNPNN.ImplicationR  = 'Random (-1std < R < +1std)';
    elseif (data.r > data.rthreshpos1) &&  (data.r < data.rthreshpos2)
        output_statsNPNN.ImplicationR  = 'Random (+1std < R < +2std)';
    elseif (data.r > data.rthreshpos2)
        output_statsNPNN.ImplicationR  = 'Uniform (R > +2td)';
    else
        output_statsNPNN.ImplicationR  =  'Unknown outcome';
    end
    
    if (data.r > data.rthreshneg2) &&  (data.r < data.rthreshpos2)
        if  (data.c < data.cthreshneg2)
            output_statsNPNN.ImplicationC  = 'Not Significant (c < -2std)';
        elseif (data.c > data.cthreshneg2) &&  (data.c < data.cthreshneg1)
            output_statsNPNN.ImplicationC  = 'Significant (-2std < c < -1std)';
        elseif (data.c > data.cthreshneg1) &&  (data.c < data.cthreshpos1)
            output_statsNPNN.ImplicationC  = 'Significant (-1std < c < +1std)';
        elseif (data.c > data.cthreshpos1) &&  (data.c < data.cthreshpos2)
            output_statsNPNN.ImplicationC  = 'Significant (+1std < c < +2std)';
        elseif (data.c > data.cthreshpos2)
            output_statsNPNN.ImplicationC  = 'Not significant (c > +2std)';
        end
    else
        output_statsNPNN.ImplicationC  = 'Not applicable';
    end
    
end

% % %
% 'ScavangedPoisson'

% Store for Scavenged Poisson NN, k = 1
store = [   1.8528    1.6199    1.2127    0.1860   10; ...
    1.7658    1.3605    1.1170    0.0902   30; ...
    1.6268    1.2949    1.0835    0.0665   50; ...
    1.5928    1.2184    1.0578    0.0442  100; ...
    1.5882    1.1939    1.0408    0.0306  200; ...
    1.6120    1.1862    1.0338    0.0249  300; ...
    1.6102    1.1525    1.0261    0.0187  500; ...
    1.55      1.1031       1.0178     0.012663  1000];

re = 3/(4* sqrt(rho_0));  output_statsK1NN.re = re;
sde = 0.272249/( sqrt(data.NN*rho_0));  output_statsK1NN.sde = sde;
c = (ra - re)/sde;   output_statsK1NN.c = c;
r = ra/re;           output_statsK1NN.r = r;

output_statsK1NN.cthreshneg1 = interp1([store(:,5); 10001], [store(:,1)-1*store(:,2); -2],data.nNN,'linear');
output_statsK1NN.cthreshneg2 = interp1([store(:,5); 10001], [store(:,1)-2*store(:,2); -2],data.nNN,'linear');
output_statsK1NN.cthreshpos1 = interp1([store(:,5); 10001], [store(:,1)+1*store(:,2); 2],data.nNN,'linear');
output_statsK1NN.cthreshpos2 = interp1([store(:,5); 10001], [store(:,1)+2*store(:,2); 2],data.nNN,'linear');

output_statsK1NN.rthreshneg1 = interp1([store(:,5); 10001], [store(:,3)-1*store(:,4); 1],data.nNN,'linear');
output_statsK1NN.rthreshneg2 = interp1([store(:,5); 10001], [store(:,3)-2*store(:,4); 1],data.nNN,'linear');
output_statsK1NN.rthreshpos1 = interp1([store(:,5); 10001], [store(:,3)+1*store(:,4); 1],data.nNN,'linear');
output_statsK1NN.rthreshpos2 = interp1([store(:,5); 10001], [store(:,3)+2*store(:,4); 1],data.nNN,'linear');

% Ideal values of R and C
output_statsK1NN.idealc = interp1([store(:,5); 10001], [store(:,1); 0],data.nNN,'linear');
output_statsK1NN.idealr = interp1([store(:,5); 10001], [store(:,3); 1],data.nNN,'linear');

if  (data.r < data.rthreshneg2)
    output_statsK1NN.ImplicationR  = 'Clustered (R < -2std)';
elseif (data.r > data.rthreshneg2) &&  (data.r < data.rthreshneg1)
    output_statsK1NN.ImplicationR  = 'Random (-2std < R < -1std)';
elseif (data.r > data.rthreshneg1) &&  (data.r < data.rthreshpos1)
    output_statsK1NN.ImplicationR  = 'Random (-1std < R < +1std)';
elseif (data.r > data.rthreshpos1) &&  (data.r < data.rthreshpos2)
    output_statsK1NN.ImplicationR  = 'Random (+1std < R < +2std)';
elseif (data.r > data.rthreshpos2)
    output_statsK1NN.ImplicationR  = 'Uniform (R > +2td)';
else
    output_statsK1NN.ImplicationR  =  'Unknown outcome';
end

if (data.r > data.rthreshneg2) &&  (data.r < data.rthreshpos2)
    if  (data.c < data.cthreshneg2)
        output_statsK1NN.ImplicationC  = 'Not Significant (c < -2std)';
    elseif (data.c > data.cthreshneg2) &&  (data.c < data.cthreshneg1)
        output_statsK1NN.ImplicationC  = 'Significant (-2std < c < -1std)';
    elseif (data.c > data.cthreshneg1) &&  (data.c < data.cthreshpos1)
        output_statsK1NN.ImplicationC  = 'Significant (-1std < c < +1std)';
    elseif (data.c > data.cthreshpos1) &&  (data.c < data.cthreshpos2)
        output_statsK1NN.ImplicationC  = 'Significant (+1std < c < +2std)';
    elseif (data.c > data.cthreshpos2)
        output_statsK1NN.ImplicationC  = 'Not significant (c > +2std)';
    end
else
    output_statsK1NN.ImplicationC  = 'Not applicable';
end


% % %
% (data.setkvalue == 2)

% Store for Scavenged Poisson NN, k = 2
store = [  2.7434       1.8609        1.269      0.18243           10; ...
    2.6375       1.4453        1.144     0.078935           30; ...
    2.5356       1.4476       1.1065      0.06082           50; ...
    2.4224       1.3107       1.0716     0.038743          100; ...
    2.3993        1.194         1.05     0.024894          200; ...
    2.3637       1.2214       1.0402     0.020774          300; ...
    2.3169       1.2321       1.0305     0.016221          500; ...
    2.3382       1.1721       1.0218     0.010906         1000];


re = 15/(16* sqrt(rho_0));  output_statsK2NN.re = re;
sde = 0.275723/( sqrt(data.NN*rho_0));  output_statsK2NN.sde = sde;
c = (ra - re)/sde;   output_statsK2NN.c = c;
r = ra/re;           output_statsK2NN.r = r;

output_statsK2NN.cthreshneg1 = interp1([store(:,5); 10001], [store(:,1)-1*store(:,2); -2],data.nNN,'linear');
output_statsK2NN.cthreshneg2 = interp1([store(:,5); 10001], [store(:,1)-2*store(:,2); -2],data.nNN,'linear');
output_statsK2NN.cthreshpos1 = interp1([store(:,5); 10001], [store(:,1)+1*store(:,2); 2],data.nNN,'linear');
output_statsK2NN.cthreshpos2 = interp1([store(:,5); 10001], [store(:,1)+2*store(:,2); 2],data.nNN,'linear');

output_statsK2NN.rthreshneg1 = interp1([store(:,5); 10001], [store(:,3)-1*store(:,4); 1],data.nNN,'linear');
output_statsK2NN.rthreshneg2 = interp1([store(:,5); 10001], [store(:,3)-2*store(:,4); 1],data.nNN,'linear');
output_statsK2NN.rthreshpos1 = interp1([store(:,5); 10001], [store(:,3)+1*store(:,4); 1],data.nNN,'linear');
output_statsK2NN.rthreshpos2 = interp1([store(:,5); 10001], [store(:,3)+2*store(:,4); 1],data.nNN,'linear');

% Ideal values of R and C
output_statsK2NN.idealc = interp1([store(:,5); 10001], [store(:,1); 0],data.nNN,'linear');
output_statsK2NN.idealr = interp1([store(:,5); 10001], [store(:,3); 1],data.nNN,'linear');

if  (data.r < data.rthreshneg2)
    output_statsK2NN.ImplicationR  = 'Clustered (R < -2std)';
elseif (data.r > data.rthreshneg2) &&  (data.r < data.rthreshneg1)
    output_statsK2NN.ImplicationR  = 'Random (-2std < R < -1std)';
elseif (data.r > data.rthreshneg1) &&  (data.r < data.rthreshpos1)
    output_statsK2NN.ImplicationR  = 'Random (-1std < R < +1std)';
elseif (data.r > data.rthreshpos1) &&  (data.r < data.rthreshpos2)
    output_statsK2NN.ImplicationR  = 'Random (+1std < R < +2std)';
elseif (data.r > data.rthreshpos2)
    output_statsK2NN.ImplicationR  = 'Uniform (R > +2td)';
else
    output_statsK2NN.ImplicationR  =  'Unknown outcome';
end

if (data.r > data.rthreshneg2) &&  (data.r < data.rthreshpos2)
    if  (data.c < data.cthreshneg2)
        output_statsK2NN.ImplicationC  = 'Not Significant (c < -2std)';
    elseif (data.c > data.cthreshneg2) &&  (data.c < data.cthreshneg1)
        output_statsK2NN.ImplicationC  = 'Significant (-2std < c < -1std)';
    elseif (data.c > data.cthreshneg1) &&  (data.c < data.cthreshpos1)
        output_statsK2NN.ImplicationC  = 'Significant (-1std < c < +1std)';
    elseif (data.c > data.cthreshpos1) &&  (data.c < data.cthreshpos2)
        output_statsK2NN.ImplicationC  = 'Significant (+1std < c < +2std)';
    elseif (data.c > data.cthreshpos2)
        output_statsK2NN.ImplicationC  = 'Not significant (c > +2std)';
    end
else
    output_statsK2NN.ImplicationC  = 'Not applicable';
end

