function [output_statsPNN] = CalculatePlanetPNSLstats(data)

stat = data.distances;
ra = mean(stat);
data.NN = length(stat);

if  strcmp(data.PlanetDatasetSize, 'Whole')
    rho_0 = data.NN/(ellarea(data.PlanetRadius(1),data.PlanetRadius(2)));
    load NNbias_fullsphere_k_0.dat
    store =  NNbias_fullsphere_k_0(:, [4, 5, 2, 3, 1]); %#ok
elseif strcmp(data.PlanetDatasetSize, 'Half')
    load NNbias_halfsphere_k_0.dat
    store =  NNbias_halfsphere_k_0(:, [4, 5, 2, 3, 1]); %#ok
    rho_0 = data.NN/(ellarea(data.PlanetRadius(1),data.PlanetRadius(2))/2);
elseif strcmp(data.PlanetDatasetSize, 'Third')
    load NNbias_thirdsphere_k_0.dat
    store =  NNbias_thirdsphere_k_0(:, [4, 5, 2, 3, 1]); %#ok
    rho_0 = data.NN/(ellarea(data.PlanetRadius(1),data.PlanetRadius(2))/3);
elseif strcmp(data.PlanetDatasetSize, 'Quarter')
    load NNbias_quartersphere_k_0.dat
    store =  NNbias_quartersphere_k_0(:, [4, 5, 2, 3, 1]); %#ok
    rho_0 = data.NN/(ellarea(data.PlanetRadius(1),data.PlanetRadius(2))/4);
else
    load NNbias_flat_k_0.dat
    store =  NNbias_flat_k_0(:, [4, 5, 2, 3, 1]); %#ok
    rho_0 = data.NN/(data.chull_area*pixsize^2);
end

% % % %
% Calculate R and C

re = 1/(2* sqrt(rho_0));  output_statsPNN.re = re;
sde = 0.26136/( sqrt(data.NN*rho_0));  output_statsPNN.sde = sde;
c = (ra - re)/sde;   output_statsPNN.c = c;
r = ra/re;           output_statsPNN.r = r;

% Interpolate to find an approximate limit

output_statsPNN.cthreshneg1 = interp1([store(:,5); 100001], [store(:,1)-1*store(:,2); -2],data.NN,'linear');
output_statsPNN.cthreshneg2 = interp1([store(:,5); 100001], [store(:,1)-2*store(:,2); -2],data.NN,'linear');
output_statsPNN.cthreshpos1 = interp1([store(:,5); 100001], [store(:,1)+1*store(:,2); 2],data.NN,'linear');
output_statsPNN.cthreshpos2 = interp1([store(:,5); 100001], [store(:,1)+2*store(:,2); 2],data.NN,'linear');

output_statsPNN.rthreshneg1 = interp1([store(:,5); 100001], [store(:,3)-1*store(:,4); 1],data.NN,'linear');
output_statsPNN.rthreshneg2 = interp1([store(:,5); 100001], [store(:,3)-2*store(:,4); 1],data.NN,'linear');
output_statsPNN.rthreshpos1 = interp1([store(:,5); 100001], [store(:,3)+1*store(:,4); 1],data.NN,'linear');
output_statsPNN.rthreshpos2 = interp1([store(:,5); 100001], [store(:,3)+2*store(:,4); 1],data.NN,'linear');

% Ideal values of R and C
output_statsPNN.idealc = interp1([store(:,5); 100001], [store(:,1); 0],data.NN,'linear');
output_statsPNN.idealr = interp1([store(:,5); 100001], [store(:,3); 1],data.NN,'linear');


if  (data.r < data.rthreshneg2)
    output_statsPNN.ImplicationR  = 'Clustered (R < -2std)';
elseif (data.r > data.rthreshneg2) &&  (data.r < data.rthreshneg1)
    output_statsPNN.ImplicationR  = 'Random (-2std < R < -1std)';
elseif (data.r > data.rthreshneg1) &&  (data.r < data.rthreshpos1)
        output_statsPNN.ImplicationR  = 'Random (-1std < R < +1std)';
elseif (data.r > data.rthreshpos1) &&  (data.r < data.rthreshpos2)
        output_statsPNN.ImplicationR  = 'Random (+1std < R < +2std)';
elseif (data.r > data.rthreshpos2)
        output_statsPNN.ImplicationR  = 'Uniform (R > +2td)';
else
        output_statsPNN.ImplicationR  =  'Unknown outcome';
end

if  (data.r > data.rthreshneg2) &&  (data.r < data.rthreshpos2)
    if  (data.c < data.cthreshneg2)
        output_statsPNN.ImplicationC  = 'Not Significant (c < -2std)';
    elseif (data.c > data.cthreshneg2) &&  (data.c < data.cthreshneg1)
        output_statsPNN.ImplicationC  = 'Significant (-2std < c < -1std)';
    elseif (data.c > data.cthreshneg1) &&  (data.c < data.cthreshpos1)
        output_statsPNN.ImplicationC  = 'Significant (-1std < c < +1std)';
    elseif (data.c > data.cthreshpos1) &&  (data.c < data.cthreshpos2)
        output_statsPNN.ImplicationC  = 'Significant (+1std < c < +2std)';
    elseif (data.c > data.cthreshpos2)
        output_statsPNN.ImplicationC  = 'Not significant (c > +2std)';
    end
else
    output_statsPNN.ImplicationC  = 'Not applicable';
    
end
