function [data] = CentroidProcess_v02(data)

% Function to produce the plots for the GIAS nearest neighbour analysis
% GUI from an input image of centroid positions rather than bubbles

% Author: Ciaran Beggan
% Created: 28-03-2008
% Last Modified: 18-11-2010

% Version 0.1: Dummy function
%
% Version 0.2: 

if data.NNonlylist
    % Check and remove duplicate entries
    centroid_list_for_NN_processing = unique([data.input1(:,1), data.input1(:,2)], 'rows');
    
    % Plot the points in Axes1
    set(gcbf,'CurrentAxes',findobj(gcbf,'Tag','Axes1'));
    cla reset
    
    data.centroid = centroid_list_for_NN_processing;
    data.allpoints = data.centroid; % For the output file
    plot(data.centroid(:,1)- min(data.centroid(:,1)),...
            data.centroid(:,2)-min(data.centroid(:,2)), 'b+')
    [data.k, data.chull_area] = convhull(data.centroid(:,1), data.centroid(:,2));
    if data.CheckInputHullArea          % The user can manually enter the Hull area here
        data.chull_area = data.InputHullArea;
    end
    
    hold on; plot(data.centroid(data.k,1)- min(data.centroid(:,1)),data.centroid(data.k,2)-min(data.centroid(:,2)),'r-+')
    
    set(gca,'Tag','Axes1');
    set(gcbf,'Userdata',data);
    
    % Axes6 Plot: Nearest Neighbour Histogram
    % Remove points on the convex hull if ignore Boundary box is ticked
    intpoints = data.centroid;
    if data.IgnoreBoundaryBubbles     
        intpoints(data.k,:) = [];
    end

    data.NN = length(intpoints);    
    sqdistances = squareform(pdist([intpoints(:,1) intpoints(:,2)])) + diag(ones(data.NN,1)*99999);
    data.distances = min(sqdistances);
    
    data.NNoid = zeros(size(data.distances));
    % A rather lazy way to find the positions of the NN object ID
    for i = 1:length(data.distances)
        pos = find(data.distances(i) == sqdistances(:,i));
        data.NNoid(i) = pos(1);
    end
    data.centroid = intpoints;
    
    data = PlotPoissonNNHist_v01(data);

    data = WriteOutNNStatistics(data);

    data = PlotNNRandCgraphs(data);
    
    data = PlotNNSkewvsKurtosis(data);
    

elseif data.PlanetaryData
    % Check and remove duplicate entries
    centroid_list_for_NN_processing = unique([data.input1(:,1), data.input1(:,2)], 'rows');
    % Make sure the data arrives in --[Lon, Lat]-- otherwise strange things
    % may happen ...
    data.centroid = [centroid_list_for_NN_processing(:,1) ,centroid_list_for_NN_processing(:,2)];
    data.allpoints = data.centroid; % For the output file

    [data.k, data.chull_area] = convhull(data.centroid(:,1), data.centroid(:,2));
    intpoints = data.centroid;
    if data.CheckInputHullArea          % The user can manually enter the Hull area here
        data.chull_area = data.InputHullArea;
    end
    if data.IgnoreBoundaryBubbles
        intpoints(data.k,:) = [];
    end
    
   
    % Plot the points in Axes1
    set(gcbf,'CurrentAxes',findobj(gcbf,'Tag','Axes1'));
    cla reset
    plot(data.centroid(:,1), data.centroid(:,2), 'b+')
    hold on; plot(data.centroid(data.k,1),data.centroid(data.k,2),'r-+')
    axis tight
    set(gca,'Tag','Axes1');
    
    
    centroids = intpoints;
    % Axes16 Plot: Planetary Nearest Neighbour Histogram
    data.NN = length(centroids);
    sqdistances = squareform(pdist([centroids ones(length(centroids),1)*data.PlanetRadius(1) ones(length(centroids),1)*data.PlanetRadius(2)], 'vincenty')) ...
                + diag(ones(length(centroids),1))*99999;
    data.distances = min(sqdistances);  % Distances are in km
    
    data.PlanetNNoid = zeros(size(data.distances));
    % A rather lazy way to find the positions of the NN object ID
    for i = 1:length(data.distances)
        pos = find(data.distances(i) == sqdistances(:,i));
        data.PlanetNNoid(i) = pos(1);
    end
    
    data = PlotPlanetPoissonNNHist_v01(data);
    data = WriteOutPlanetNNStatistics(data);
    data = PlotPlanetNNRandCgraphs(data);
    data = PlotPlanetNNSkewvsKurtosis(data);

else
    error('CentroidProcess - no data type option selected')
end

set(gcbf,'Userdata',data)
