function InputPanelv2(h0, colo)

% % % TOP LEFT INPUTS / BUTTONS
% Last updated to remove buttons from the original input panel
% Date last modified: 07-11-2011
% --------------- Quit button -------------------------------
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'ListboxTop',0, ...
    'ForegroundColor',[0 0 1], ...
    'FontSize',10, ...
    'FontWeight', 'bold', ...
    'ListboxTop',0, ...
    'Position',[0.217 0.724 0.09 0.045],...
    'Style','push', ...
    'String','Quit', ...
    'Tag','Exit', ...
    'Callback','close(gcf)');

% ------------------- axes for image 1 ------------------------------------
% % % INPUT
h1 = axes('Parent',h0, ...
    'Box','on', ...
    'CameraUpVector',[0 1 0], ...
    'CameraUpVectorMode','manual', ...
    'Color',[1 1 1], ...
    'FontSize',8, ...
    'Position',[0.02 0.72 0.18 0.26], ...
    'Tag','Axes1', ...
    'NextPlot','add', ...
    'XColor',[0 0 0], ...
    'XTickMode','manual', ...
    'YColor',[0 0 0], ...
    'YTickMode','manual', ...
    'ZColor',[0 0 0]);

logo = imread('GIAS_Logo.png');
imshow(logo, 'Parent', h1,'InitialMagnification',100)
axis image; box on;

% message saying what this is and who I am...
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'BackgroundColor',colo, ...
    'FontSize',12, ...
    'FontWeight', 'bold', ...
    'ForegroundColor',[0 0 0], ...
    'ListboxTop',0, ...
    'Position',[0.35  0.95 0.4 0.04], ...
    'Style','text', ...
    'String',' Geological Image Analysis Software ', ...
    'TooltipString','(c) Ciaran Beggan (BGS) and Chris Hamilton (NASA) [gias@geoanalysis.org]  {version 2.1 (07 Nov 2011)}');


% % display image names
% -----------------------------------------------------------------
% Display Input Parameters label
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'BackgroundColor',colo, ...
    'FontSize',10, ...
    'FontWeight', 'bold', ...
    'ListboxTop',0, ...
    'Position',[0.26    0.925   0.2245    0.0266], ...
    'String','Input Parameters', ...
    'Style','text', ...
    'Tag','outputlabel');

% Button for loading image 1
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'Callback','gias_guifun_v06 loadsem; gias_guifun_v06 input1Select; ', ...
    'ListboxTop',0, ...
    'ForegroundColor',[0 0 1], ...
    'FontWeight', 'bold', ...
    'FontSize', 10, ...
    'Position',[0.217 0.896 0.09 0.045], ...
    'String','Load Data ', ...
    'TooltipString','Load image or data file', ...
    'Tag','Pushbutton2');

% Processing button for Computing Statistics
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'Callback','gias_guifun_v06 ImageProcess', ...
    'ListboxTop',0, ...
    'ForegroundColor',[0 0 1], ...
    'FontWeight', 'bold', ...
    'FontSize', 10, ...
    'Position',[0.217 0.837 0.09 0.045], ...
    'String','Process >>', ...
    'TooltipString','Begin Processing the Image/Data', ...
    'Tag','Pushbutton1');

% Processing button for outputting Statistics
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'Callback','gias_guifun_v06 OutputData', ...
    'ListboxTop',0, ...
    'ForegroundColor',[0 0 1], ...
    'FontWeight', 'bold', ...
    'FontSize', 10, ...
    'Position',[0.217 0.777 0.09 0.045], ...
    'String','Save Results ...', ...
    'TooltipString','Save the statistical data to file', ...
    'Tag','Pushbutton3');

% % TOP RIGHT CONTROLS - - - - - -- - -

% Input Box for pixel size input in mm^2

% String for pixel size
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'Position',[0.753 0.894 0.065 0.025], ...
    'BackgroundColor',colo, ...
    'FontSize',10, ...
    'ListboxTop',0, ...
    'ForegroundColor',[0 0 0], ...
    'HorizontalAlignment','left', ...
    'Style', 'text', ...
    'String','Pixel Size:', ...
    'TooltipString','Enter Pixel Size', ...
    'Tag','EnterPixelSize');

% Input box for pixel size
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'Callback','gias_guifun_v06 setPixelUnitSelection', ...
    'BackgroundColor',[0.3 0.6 0.2], ...
    'FontSize',10, ...
    'ForegroundColor', [1 1 1], ...
    'Position', [0.82 0.894 0.05 0.025], ...
    'String','1', ...
    'Style','edit', ...
    'Tag','setPixelSize', ...
    'TooltipString','Enter Pixel Size (select correct Pixel Units )');

% % Pixel Unit selection %% %
uicontrol('Parent',h0, 'Style','text', ...
    'Units','normalized', ...
    'BackgroundColor',colo, ...
    'FontSize',8, 'ListboxTop',0, ...
    'ForegroundColor',[0 0 0], ...
    'HorizontalAlignment','center', ...
    'Position',[0.9115 0.892 0.07 0.026], ...
    'String','Pixel Units');

uicontrol('Style','popupmenu','String','m|m^2|mm|mm^2|um|um^2','TooltipString','enter pixel units',...
    'Units','normalized', 'FontSize',8,'BackgroundColor',colo,...
    'pos',[0.875 0.9125 0.045 0.01],'Parent',h0, 'Tag', 'PixelUnits', 'Callback','gias_guifun_v06 setPixelUnitSelection' );

% Text to denote that degrees are now in assumed for the Planetary
% NN with area being in m^2
uicontrol('Style','text',...
    'Parent',h0, 'Units','normalized', ...
    'BackgroundColor',colo, 'FontSize',10, ...
    'ListboxTop',0, 'ForegroundColor',[0 0 1 ], ...
    'HorizontalAlignment','left', ...
    'Position',[0.785 0.852 0.20 0.027], ...
    'Units','normalized', ...
    'BackgroundColor',colo, ...
    'String',' ',...
    'Tag','PlanetUnit', ...
    'TooltipString','Planetary Body Data Loaded');


% % Ignore Boundary pixel check box
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'BackgroundColor',colo, ...
    'Callback','gias_guifun_v06 setIgnoreBoundaryBubbles', ...
    'FontSize',10, ...
    'ForegroundColor',[1 1 0], ...
    'Value', 1, ...
    'Position',[0.8 0.79 0.017 0.047], ... %[0.759 0.7 0.017 0.047]
    'Style','checkbox',...
    'Tag','IgnoreBoundaryBubbles', ...
    'TooltipString','Ignore Boundary Touching Objects ');

uicontrol('Parent',h0, 'Units','normalized', ...
    'BackgroundColor',colo, 'FontSize',10, ...
    'ListboxTop',0, 'ForegroundColor',[0 0 0], ...
    'HorizontalAlignment','left', ...
    'Position',[0.82 0.80 0.15 0.023], ... % [0.78 0.71 0.176 0.025]
    'String','Ignore Hull Boundary Objects', ...                        % Label on the slider
    'Style','text', ...
    'TooltipString','Ignore Objects whose boundaries touch the edge of the image');

% % Input Hull Area (if the user requires it)
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'BackgroundColor',colo, ...
    'Callback','gias_guifun_v06 setCheckInputHullArea', ...
    'FontSize',10, ...
    'ForegroundColor',[1 1 0], ...
    'Value', 0, ...
    'Position',[0.8 0.74 0.017 0.047], ... %[0.759 0.7 0.017 0.047]
    'Style','checkbox',...
    'Tag','CheckInputHullArea', ...
    'TooltipString','Input the Area covered by the data');

uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'Callback','gias_guifun_v06 setInputHullArea', ...
    'BackgroundColor',[0.3 0.6 0.2], ...
    'FontSize',10, ...
    'ForegroundColor', [1 1 1], ...
    'Position', [0.82 0.75 0.123 0.028], ...
    'String','Enter Hull Area in units', ...
    'Style','edit', ...
    'Tag','textInputHullArea', ...
    'TooltipString','Enter Area covered by the data (in the square of the defined unit e.g. m^2) ');


% % Set NN input image
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'BackgroundColor',colo, ...
    'Callback','gias_guifun_v06 setNNCentroidImageonly', ...
    'FontSize',11, ...
    'ForegroundColor',[1 1 0], ...
    'Value', 0, ...
    'Position',[0.321 0.838 0.016 0.036], ...
    'Style','checkbox',...
    'Tag','NNCentroidImageonly', ...
    'TooltipString','Input a Nearest Neighbor Centroid Image only');

uicontrol('Parent',h0, 'Units','normalized', ...
    'BackgroundColor',colo, 'FontSize',10, ...
    'ListboxTop',0, 'ForegroundColor',[0 0 0], ...
    'HorizontalAlignment','left', ...
    'Position',[0.34 0.847 0.11 0.022], ...
    'String','NN Input Image', ...
    'Style','text', ...
    'TooltipString','');

% % Set NN pixel list
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'BackgroundColor',colo, ...
    'Callback','gias_guifun_v06 setNNPixelListonly', ...
    'FontSize',11, ...
    'ForegroundColor',[1 1 0], ...
    'Value', 0, ...
    'Position',[0.321 0.798 0.016 0.036], ...
    'Style','checkbox',...
    'Tag','NNCentroidListonly', ...
    'TooltipString','Input a Nearest Neighbor Centroid List only');

uicontrol('Parent',h0, 'Units','normalized', ...
    'BackgroundColor',colo, 'FontSize',10, ...
    'ListboxTop',0, 'ForegroundColor',[0 0 0], ...
    'HorizontalAlignment','left', ...
    'Position',[0.34 0.807 0.11 0.022], ...
    'String','NN Centroid List ', ...
    'Style','text', ...
    'TooltipString','');

% % Set Invert Image
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'BackgroundColor',colo, ...
    'Callback','gias_guifun_v06 setInvertImage', ...
    'FontSize',11, ...
    'ForegroundColor',[1 1 0], ...
    'Value', 0, ...
    'Position',[0.321 0.878 0.016 0.036], ...
    'Style','checkbox',...
    'Tag','InvertImage', ...
    'TooltipString','Invert the thresholding of the input image');

uicontrol('Parent',h0, 'Units','normalized', ...
    'BackgroundColor',colo, 'FontSize',10, ...
    'ListboxTop',0, 'ForegroundColor',[0 0 0], ...
    'HorizontalAlignment','left', ...
    'Position',[0.34 0.887 0.11 0.022], ...
    'String','Invert Input Image ', ...
    'Style','text', ...
    'TooltipString','');

% % Set Planetary Data only switch
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'BackgroundColor',colo, ...
    'Callback','gias_guifun_v06 setPlanetaryDataOnly', ...
    'FontSize',11, ...
    'ForegroundColor',[1 1 0], ...
    'Value', 0, ...
    'Position',[0.321 0.76 0.016 0.036], ...
    'Style','checkbox',...
    'Tag','PlanetaryData', ...
    'TooltipString','Use Planetary NN Tab only');

uicontrol('Parent',h0, 'Units','normalized', ...
    'BackgroundColor',colo, 'FontSize',10, ...
    'ListboxTop',0, 'ForegroundColor',[0 0 0], ...
    'HorizontalAlignment','left', ...
    'Position',[0.34 0.767 0.11 0.022], ...
    'String','Planetary Data', ...
    'Style','text', ...
    'TooltipString','Use Planetary NN Tab only');

% Select Planet %% REPLACE by Pop-up file select dialog
uicontrol('Style','text',...
    'Parent',h0, 'Units','normalized', ...
    'BackgroundColor',colo, 'FontSize',10, ...
    'ListboxTop',0, 'ForegroundColor',[0 0 1 ], ...
    'HorizontalAlignment','left', ...
    'Position',[0.34 0.737 0.08 0.022], ...
    'Units','normalized', ...
    'BackgroundColor',colo, ...
    'String',' ',...
    'Tag','PlanetName', ...
    'TooltipString','Planetary Body Data Loaded');




%---------------------------------------------------

% % OUTPUT Statistics to File covered under Save Results button

uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'BackgroundColor',colo, ...
    'FontSize',10, ...
    'FontWeight', 'bold', ...
    'ListboxTop',0, ...
    'Position',[0.73    0.925    0.2245    0.0266], ...
    'String','Spatial Parameters', ...
    'Style','text', ...
    'Tag','outputlabel');
%
%
% % String for creating filename
% uicontrol('Parent',h0, ...
%     'Units','normalized', ...
%     'Position',[0.755 0.9 0.2 0.025], ...
%     'BackgroundColor',colo, ...
%     'FontSize',10, ...
%     'ListboxTop',0, ...
%     'ForegroundColor',[0 0 0], ...
%     'HorizontalAlignment','center', ...
%     'Style', 'text', ...
%     'String','Enter filename for output data:', ...
%     'TooltipString','Enter filename', ...
%     'Tag','EnterFilename');
%
% % Input box for filename input
% uicontrol('Parent',h0, ...
%     'Units','normalized', ...
%     'Callback','gias_guifun_v06 setOutputName', ...
%     'BackgroundColor',[0.3 0.6 0.2], ...
%     'FontSize',10, ...
%     'ForegroundColor', [1 1 1], ...
%     'Position', [0.755 0.865 0.2 0.035], ...
%     'String','Output', ...
%     'Style','edit', ...
%     'Tag','textFilename', ...
%     'TooltipString','Enter Filename');


% Detection Paramters
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'BackgroundColor',colo, ...
    'FontSize',10, ...
    'FontWeight', 'bold', ...
    'ListboxTop',0, ...
    'Position',[0.48    0.925    0.2245    0.0266], ...
    'String','Detection Parameters', ...
    'Style','text', ...
    'Tag','outputlabel');

% % Ignore objects smaller than x pixels square
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'BackgroundColor',colo, ...
    'Callback','gias_guifun_v06 setIgnoreSizeLevel', ...
    'FontSize',10, ...
    'ForegroundColor',[1 1 1], ...
    'BackgroundColor',[0.3 0.6 0.2], ...
    'String',10, ...
    'Position',[0.562 0.869 0.05 0.025], ...
    'Style','edit',...
    'Tag','IgnoreSizeLevel', ...
    'TooltipString','Set the size threshold to ignore objects smaller (in pixels) than this');


uicontrol('Parent',h0, 'Units','normalized', ...
    'BackgroundColor',colo, 'FontSize',10, ...
    'ListboxTop',0, 'ForegroundColor',[0 0 1 ], ...
    'HorizontalAlignment','left', ...
    'Position',[0.512 0.894 0.141 0.025], ...
    'String','Minimum Object Area (pixels)', ...
    'Style','text', 'Tag','textIgnoreBubbleSize', ...
    'TooltipString','Ignore Object Area (in Pixels) smaller than this');

% % Set Max bubble size threshold
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'BackgroundColor',colo, ...
    'Callback','gias_guifun_v06 setIgnoreMaxSizeLevel', ...
    'FontSize',10, ...
    'ForegroundColor',[1 1 1], ...
    'BackgroundColor',[0.3 0.6 0.2], ...
    'String','Max', ...
    'Position',[0.562 0.814 0.05 0.025], ...
    'Style','edit',...
    'Tag','IgnoreMaxSizeLevel', ...
    'TooltipString','Set the Maximum size threshold value (in Pixels) for the image');

uicontrol('Parent',h0, 'Units','normalized', ...
    'BackgroundColor',colo, 'FontSize',10, ...
    'ListboxTop',0, 'ForegroundColor',[0 0 1 ], ...
    'HorizontalAlignment','left', ...
    'Position',[0.512 0.838 0.144 0.025], ...
    'String','Maximum Object Area (pixels)', ...
    'Style','text', 'Tag','textMaxDetectionThreshold', ...
    'TooltipString','Ignore Object Areas (in Pixels) larger than Value');

% % Set threshold value for bubbles
% % Create a min/max text boxes for the values

uicontrol('Parent',h0, 'Units','normalized', ...
    'BackgroundColor',colo, 'FontSize',10, ...
    'ListboxTop',0, 'ForegroundColor',[0 0 1 ], ...
    'HorizontalAlignment','left', ...
    'Position',[0.512 0.782 0.18 0.025], ...
    'String','Black / White Threshold Level', ...
    'Style','text', 'Tag','textDetectionThreshold', ...
    'TooltipString','');

% Input box for pixel size
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'Callback','gias_guifun_v06 setThresholdLevel', ...
    'BackgroundColor',[0.3 0.6 0.2], ...
    'FontSize',10, ...
    'ForegroundColor', [1 1 1], ...
    'Position', [0.512 0.757 0.045 0.025], ...
    'String','0', ...
    'Style','edit', ...
    'Tag','DetectionThresholdLevelLower', ...
    'TooltipString','Enter Lower Threshold Digital Number');

uicontrol('Parent',h0, 'Units','normalized', ...
    'BackgroundColor',colo, 'FontSize',10, ...
    'ListboxTop',0, 'ForegroundColor',[0 0 1 ], ...
    'HorizontalAlignment','left', ...
    'Position',[0.56 0.757 0.18 0.025], ...
    'String','Low / High', ...
    'Style','text', ...
    'TooltipString','');

uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'Callback','gias_guifun_v06 setThresholdLevel', ...
    'BackgroundColor',[0.3 0.6 0.2], ...
    'FontSize',10, ...
    'ForegroundColor', [1 1 1], ...
    'Position', [0.615 0.757 0.045 0.025], ...
    'String','250', ...
    'Style','edit', ...
    'Tag','DetectionThresholdLevelUpper', ...
    'TooltipString','Enter Upper Threshold Digital Number');


% Normalised Poisson Threshold
uicontrol('Parent',h0, ...
    'Units','normalized', ...
    'BackgroundColor',colo, ...
    'Callback','gias_guifun_v06 setNormPoissonThresholdLevel', ...
    'FontSize',10, ...
    'ForegroundColor',[1 1 1], ...
    'BackgroundColor',[0.3 0.6 0.2], ...
    'String',0, ...
    'Position',[0.562 0.703 0.05 0.025], ...
    'Style','edit',...
    'Tag','NormPoissonThresholdLevel', ...
    'TooltipString','Remove objects with radius (in defined units) smaller than this (N.B. units are not pixels)');

uicontrol('Parent',h0, 'Units','normalized', ...
    'BackgroundColor',colo, 'FontSize',10, ...
    'ListboxTop',0, 'ForegroundColor',[0 0 1 ], ...
    'HorizontalAlignment','left', ...
    'Position',[0.512 0.727 0.18 0.025], ...
    'String','Normalized Poisson Threshold', ...
    'Style','text', 'Tag','textNormPoissonThreshold', ...
    'TooltipString','Radius in given units');
