function [data] = PlotBubbleEccentricity(data)

% Function to produce the plot for the bubble orientations histogram

% Author: Ciaran Beggan
% Created: 19-03-2008
% Last Modified: 19-03-2008

% Version 0.1: Initial script produce eccentricity histogram and draw
%              onto the relevant axes

% Plot the Bubble Perimeter histogram
set(gcbf,'CurrentAxes',findobj(gcbf,'Tag','Axes4'));    % move to the correct axes
cla

histtemp = data.eccentricity;
num_bins = 11;

x_spaces = linspace(0,1,num_bins);

n = histc(histtemp, x_spaces);

bar(n)
h = findobj(gca,'Type','patch');
set(h,'FaceColor','r','EdgeColor','w')
set(gca,'XTickLabel', x_spaces(1:2:num_bins), 'XTick', 1:2:num_bins )
set(gca, 'YTickMode', 'auto')
xlabel('Eccentricity'), ylabel('Frequency')

set(gcbf,'Userdata',data);  
