function [data] = PlotBubbleOrientations(data)

% Function to produce the plot for the bubble orientations histogram

% Author: Ciaran Beggan
% Created: 19-03-2008
% Last Modified: 19-03-2008

% Version 0.1: Initial script produce orientations histogram and draw
%              onto the relevant axes

% Plot the Bubble Perimeter histogram
h1 = findobj(gcbf,'Tag','Axes5');
set(gcbf,'CurrentAxes',h1);    % move to the correct axes 
set(gca, 'YTickMode', 'auto');
cla reset

histtemp = deg2radorientations(data.orientations+180);
num_bins = 24;

[t,r] = rose(histtemp, num_bins);
h = polar(t,r);
patch(get(h, 'XData')', get(h, 'Ydata'), [1 0 0])

set(gca, 'Tag', 'Axes5');

set(gcbf,'Userdata',data);  
