function [data] = PlotBubblePerimeters(data)

% Function to produce the plot for the object perimeters histogram and a
% graph of actual perimeter vs. a circle of equal area perimeter and a
% histogram of the equal area circle radius

% Author: Ciaran Beggan
% Created: 19-03-2008
% Last Modified: 16-05-2008

% Version 0.11: Added in the code to perform the equal area radius
%               histogram and corrected the unit meaurements
% Version 0.1: Initial script to process image, produce histogram and draw
%              onto the relevant axes

% Plot the Bubble Perimeter histogram 
set(gcbf,'CurrentAxes',findobj(gcbf,'Tag','Axes3'));    % move to the correct axes
cla reset

labelXUnit = get(findobj(gcbf,'Tag','NNPixelUnit'),'String');

perimeters = data.perimeters.*data.PixelSize; equiv_diameters = data.equiv_diameters.*data.PixelSize;
histtemp = perimeters(perimeters > sqrt(data.IgnoreSmallArea).*data.PixelSize);
num_bins = 12;

if (strcmp(data.BubPerimeter, 'Histogram'))
    maxper = max(histtemp)*data.PixelSize;
    minper = min(histtemp)*data.PixelSize;
    if log10(maxper) < 0
        x_spaces = (logspace(log10(minper),log10(maxper), num_bins));
    else
        x_spaces = floor(logspace(log10(minper),log10(maxper), num_bins));
    end
    
    n = histc(histtemp, x_spaces);
    y_spaces = floor(linspace(min(n), max(n)+max(n)/20, num_bins));

    bar(n)
    h = findobj(gca,'Type','patch');
    set(h,'FaceColor','r','EdgeColor','w')
    set(gca, 'YtickMode', 'auto', 'YtickMode', 'auto')
    set(gca,'XTickLabel', x_spaces(1:2:num_bins).*data.PixelSize, 'XTick', 1:2:num_bins )
 %   set(gca,'YTickLabel', y_spaces(1:2:num_bins), 'YTick', 1:num_y_ticks:max(y_spaces) )
    axis tight,xlabel(strcat('Perimeter (' ,labelXUnit(1), ')'))
    ylabel('Frequency')
elseif (strcmp(data.BubPerimeter, 'Plot'))
    plot(perimeters.*data.PixelSize, equiv_diameters.*pi.*data.PixelSize, 'r.')
    hold on, plot([0 max(equiv_diameters.*pi.*data.PixelSize)], [0 max(equiv_diameters.*pi.*data.PixelSize)], 'k--')
    set(gca, 'YtickMode', 'auto', 'YtickMode', 'auto')
    set(gca, 'XtickMode', 'auto', 'XtickMode', 'auto')
    ylabel(strcat('Equiv. Perimeter (' ,labelXUnit(1), ')')) 
    xlabel(strcat('Perimeter (' ,labelXUnit(1), ')'))
    axis tight, hold off
elseif (strcmp(data.BubPerimeter, 'RadPlot'))
    maxper = max(equiv_diameters/2)*data.PixelSize;
    minper = min(equiv_diameters/2)*data.PixelSize;
    
    % Clip the bins if the numbers are large
    if log10(maxper) < 0
        x_spaces = (logspace(log10(minper),log10(maxper), num_bins));
    else
        x_spaces = floor(logspace(log10(minper),log10(maxper), num_bins));
    end
    
    n = histc(equiv_diameters/2, x_spaces);
    y_spaces = floor(linspace(min(n), max(n)+max(n)/20, num_bins));

    bar(n)
    h = findobj(gca,'Type','patch');
    set(h,'FaceColor','r','EdgeColor','w')
    set(gca, 'YtickMode', 'auto', 'YtickMode', 'auto')
    set(gca,'XTickLabel', x_spaces(1:2:num_bins).*data.PixelSize, 'XTick', 1:2:num_bins )
 %   set(gca,'YTickLabel', y_spaces(1:2:num_bins), 'YTick', 1:num_y_ticks:max(y_spaces) )
    axis tight, xlabel(strcat('Radius (' ,labelXUnit(1), ')'))
    ylabel('Frequency')
else
    error('Plot type not recognised')
end

set(gca, 'Tag', 'Axes3');
set(gcbf,'Userdata',data);  