function [data] = PlotBubbleSizeFrequencyHist_v01(data)

% Function to produce the plots for the Bubble nearest neighbour analysis GUI

% Author: Ciaran Beggan
% Created: 19-03-2008
% Last Modified: 23-03-2008

% Version 0.11: Updated the scritp to use object area square root for the
%               phi scale. This is a fudge, but the phi scale doesn't
%               really mean much in the context of non-spherical 2D shapes
% Version 0.1: Initial script to process image, produce histogram and draw
%              onto the relevant axes

% Plot the Bubble Size frequency histogram
set(gcbf,'CurrentAxes',findobj(gcbf,'Tag','Axes2'));    % move to the correct axes
cla reset

labelXUnit = get(findobj(gcbf,'Tag','IAPixelUnit'),'String');

areas = data.areas;
maxbubble = max(areas).*data.PixelSize^2;
minbubble = min(areas).*data.PixelSize^2;

histtemp = areas(areas > data.IgnoreSmallArea);

if (strcmp(data.BubbleBinSizeOption, 'Phi'))

    x_spaces = linspace(minbubble, maxbubble, 15);
    n = histc(histtemp.*data.PixelSize^2, x_spaces);

    if ~data.BubbleYMaxAxisOption && strcmp(data.BubbleYAxisOption,'Linear')
        hb = bar(n, 'FaceColor', 'r', 'EdgeColor', 'w');
        %set(gca,'XTick', 1:2:35, 'XTickLabel', 9:-1:-8)
        set(gca, 'XTickLabel', str2num(num2str(x_spaces, 2))) %#ok
        %set(gca,'XDir','reverse')
        
    elseif data.BubbleYMaxAxisOption && strcmp(data.BubbleYAxisOption,'Linear')
        n(n > data.BubbleYAxisMaxSize) = data.BubbleYAxisMaxSize;
        hb = bar(n, 'FaceColor', 'r', 'EdgeColor', 'w');
        set(gca, 'XTickLabel', str2num(num2str(x_spaces, 2))) %#ok
        %set(gca,'XTick', 1:2:35, 'XTickLabel', 9:-1:-8)
        set(gca, 'YLim', [0 data.BubbleYAxisMaxSize])
        
        
    elseif ~data.BubbleYMaxAxisOption && strcmp(data.BubbleYAxisOption,'Log')
        [hx, hy] = stairs(n);
        plot(hx(1:2:end-1)+1/2, hy(1:2:end-1), 'r.', 'MarkerSize', 10)
        set(gca,'YTickMode', 'auto', 'YScale', 'Log')
        set(gca, 'XTickLabel', str2num(num2str(x_spaces, 2)))%#ok
        
    else
        n(n > data.BubbleYAxisMaxSize) = data.BubbleYAxisMaxSize;
        [hx, hy] = stairs(n);
        plot(hx(1:2:end-1)+1/2, hy(1:2:end-1), 'r.', 'MarkerSize', 10)
        set(gca, 'XTickLabel', str2num(num2str(x_spaces, 2)))%#ok
        set(gca,'YTickMode', 'auto', 'YScale', 'Log')
        set(gca, 'YLim', [0 data.BubbleYAxisMaxSize])
        
    end

   % xlabel('Bubble Size (Log 2 scale)'), 
    xlabel('Object Area'), ylabel('Frequency')
elseif (strcmp(data.BubbleBinSizeOption, 'Custom'))
    if strcmp(data.BubbleXAxisOption, 'Default')
        cla reset
        bins = minbubble:data.BubbleBinSize:maxbubble;
        num_bins = length(bins);

        num_x_ticks = floor(num_bins/10);
        if (num_x_ticks  == 0); num_x_ticks = 1; end
        x_spaces = floor(linspace(bins(1),bins(end), num_bins));
        n = histc(histtemp.*data.PixelSize^2, x_spaces);
        y_spaces = floor(linspace(min(n), max(n)+max(n)/20, num_bins));
        num_y_ticks = floor(max(y_spaces)/10);

        % Y-Axis settings

        if ~data.BubbleYMaxAxisOption && strcmp(data.BubbleYAxisOption,'Linear')
            bar(n)
            h = findobj(gca,'Type','patch');
            set(h,'FaceColor','r','EdgeColor','w')
            set(gca,'XTickLabel', x_spaces(1:num_x_ticks:num_bins).*data.PixelSize^2, 'XTick', 1:num_x_ticks:num_bins )
            set(gca, 'YScale', 'Linear', 'YTickLabel', y_spaces(1:num_x_ticks:num_bins), 'YTick', 1:num_y_ticks:max(y_spaces) )
            set(gca, 'FontSize', 8)
        elseif data.BubbleYMaxAxisOption && strcmp(data.BubbleYAxisOption,'Linear')
            n(n > data.BubbleYAxisMaxSize) = data.BubbleYAxisMaxSize;
            bar(n, 'FaceColor', 'r', 'EdgeColor', 'w');
            set(gca,'XTickLabel', x_spaces(1:num_x_ticks:num_bins).*data.PixelSize^2, 'XTick', 1:num_x_ticks:num_bins )
            set(gca, 'YLim', [0 data.BubbleYAxisMaxSize])
        elseif ~data.BubbleYMaxAxisOption && strcmp(data.BubbleYAxisOption,'Log')
            [hx, hy] = stairs(n);
            plot(hx(1:2:end-1)+1/2, hy(1:2:end-1), 'r.', 'MarkerSize', 10)
            set(gca,'YTickMode', 'auto', 'YScale', 'Log')
            set(gca,'XTickLabel', x_spaces(1:num_x_ticks:num_bins).*data.PixelSize^2, 'XTick', 1:num_x_ticks:num_bins )
        else
            n(n > data.BubbleYAxisMaxSize) = data.BubbleYAxisMaxSize;
            [hx, hy] = stairs(n);
            plot(hx(1:2:end-1)+1/2, hy(1:2:end-1), 'r.', 'MarkerSize', 10)
            set(gca,'YTickMode', 'auto', 'YScale', 'Log')
            set(gca,'XTickLabel', x_spaces(1:num_x_ticks:num_bins).*data.PixelSize^2, 'XTick', 1:num_x_ticks:num_bins )
        end


        xlabel(strcat('Object Area (' ,labelXUnit(1), ')')), ylabel('Frequency')

        % Custom X Axis
    elseif strcmp(data.BubbleXAxisOption , 'Custom')
        minsize = data.BubbleXAxisMinSize;
        maxsize = data.BubbleXAxisMaxSize;
        histtemp = areas(areas > minsize);
        histtemp = histtemp(histtemp < maxsize);
        bins = minsize:data.BubbleBinSize:maxsize;
        num_bins = length(bins);
        num_x_ticks = floor(num_bins/10);
        if num_x_ticks < 12
            num_x_ticks  = 2;
        end
        x_spaces = floor(linspace((min(histtemp)),(max(histtemp)), num_bins));
        n = histc(histtemp.*data.PixelSize^2, x_spaces);
        y_spaces = floor(linspace(min(n), max(n)+max(n)/20, num_bins));
       
        
        % Custom Y Axis
        % Y-Axis settings

        if ~data.BubbleYMaxAxisOption && strcmp(data.BubbleYAxisOption,'Linear')
            bar(n)
            h = findobj(gca,'Type','patch');
            set(h,'FaceColor','r','EdgeColor','w')
            set(gca,'XTickLabel', x_spaces(1:num_x_ticks:num_bins).*data.PixelSize^2, 'XTick', 1:num_x_ticks:num_bins )
            set(gca, 'YScale', 'Linear', 'YTickMode', 'auto')
            set(gca, 'FontSize', 8)
            
        elseif data.BubbleYMaxAxisOption && strcmp(data.BubbleYAxisOption,'Linear')
            n(n > data.BubbleYAxisMaxSize) = data.BubbleYAxisMaxSize;
            bar(n, 'FaceColor', 'r', 'EdgeColor', 'w');
            set(gca,'XTickLabel', x_spaces(1:num_x_ticks:num_bins).*data.PixelSize^2, 'XTick', 1:num_x_ticks:num_bins )
            set(gca, 'YLim', [0 data.BubbleYAxisMaxSize])
        elseif ~data.BubbleYMaxAxisOption && strcmp(data.BubbleYAxisOption,'Log')
            [hx, hy] = stairs(n);
            plot(hx(1:2:end-1)+1/2, hy(1:2:end-1), 'r.')
            set(gca,'YTickMode', 'auto', 'YScale', 'Log')
            set(gca,'XTickLabel', x_spaces(1:num_x_ticks:num_bins).*data.PixelSize^2, 'XTick', 1:num_x_ticks:num_bins )
        else
            n(n > data.BubbleYAxisMaxSize) = data.BubbleYAxisMaxSize;
            [hx, hy] = stairs(n);
            plot(hx(1:2:end-1)+1/2, hy(1:2:end-1), 'r.')
            set(gca,'YTickMode', 'auto', 'YScale', 'Log')
            set(gca,'XTickLabel', x_spaces(1:num_x_ticks:num_bins).*data.PixelSize^2, 'XTick', 1:num_x_ticks:num_bins )
            set(gca, 'YLim', [0 data.BubbleYAxisMaxSize])
        end
        xlabel(strcat('Object Area (' ,labelXUnit(1), ')')), ylabel('Frequency')
        
    end

end

set(gca,'Tag','Axes2');
set(gcbf,'Userdata',data)