function data = PlotNNRandCgraphs(data)

% Function to produce the R and C graphs for the Nearest Neightbour statistic summary
% for Tab 2

% Author: Ciaran Beggan
% Created: 21-04-2008
% Last Modified: 25-11-2011

% Version 0.4: Add implication of R and C onto the axes
% Version 0.3: Added in more detailed C and R curves
% Version 0.2: Added the option for drawing NN scavenged k = 1 and k = 2
%              curves
% Version 0.1: Initial script produce plots and draw
%              points into the relevant axes

% Note: the data generated here comes from a script I wrote called Baloga
% simulations which derives these values from 1000 simulations of a Poisson
% distributed image

% store = [mean(C) std(C) mean(R) std(R) N]


pixsize = data.PixelSize;
stat = data.distances*pixsize;
data.nNN = length(stat);
rho_0 = data.nNN/(data.chull_area*pixsize^2);
ra = mean(stat);

if strcmp(data.NNModelSelection, 'Poisson')
    % Store for Poisson NN
    NNbias_flat_k_0 = dlmread('skdata/NNbias_flat_k_0.dat');
    store =  NNbias_flat_k_0(:, [4, 5, 2, 3, 1]); 


    % Calculate R and C

    re = 1/(2* sqrt(rho_0));  data.re = re;
    sde = 0.26136/( sqrt(data.nNN*rho_0));  data.sde = sde;
    c = (ra - re)/sde;   data.c = c;
    r = ra/re;           data.r = r;

elseif strcmp(data.NNModelSelection, 'NormPoisson')
    
    store =  [0.98611       1.3148        1.163      0.21733     10; ...
        0.88368       1.1746       1.0843       0.1121           30; ...
        0.88167        1.167       1.0652     0.086268           50; ...
        0.85576       1.0832       1.0447     0.05662           100; ...
        0.81891       1.0696       1.0303     0.039533          200; ...
        0.78469       1.0659       1.0237     0.032471          300; ...
        0.77288       1.0543       1.0204     0.024647          500; ...
        0.7641        1.0401       1.0126     0.017193          1000];


    % Calculate R and C

    min_rpnn = data.SetNormPoissonThresholdLevel;
    
    ra = mean(stat);
    new_distances = stat(stat>min_rpnn);
    data.nNN = length(new_distances);
    if isempty(new_distances)
        
        c = 0; r = 0;
        data.c = 0;
        data.r = 0;
    else
        
        re =  (sum((new_distances.^2).*exp(-pi*rho_0*new_distances.^2)))/sum((new_distances).*exp(-pi*rho_0*new_distances.^2));

        vare = (sum((new_distances.^3).*exp(-pi*rho_0*new_distances.^2)))/sum((new_distances).*exp(-pi*rho_0*new_distances.^2)); 

        sde =  sqrt(vare)/sqrt(data.nNN);

        c = (ra - re)/sde; data.c = c; data.sde = sde;
        r = ra/re; data.r = r;
    end
elseif  strcmp(data.NNModelSelection, 'ScavangedPoisson')
    if  (data.setkvalue == 1)
        
         NNbias_flat_k_1 = dlmread('skdata\NNbias_flat_k_1.dat');
        store =  NNbias_flat_k_1(:, [4, 5, 2, 3, 1]); 
        
         % Store for Scavenged Poisson NN, k = 1
%     store = [   1.8528    1.6199    1.2127    0.1860   10; ...
%                 1.7658    1.3605    1.1170    0.0902   30; ...
%                 1.6268    1.2949    1.0835    0.0665   50; ...
%                 1.5928    1.2184    1.0578    0.0442  100; ...
%                 1.5882    1.1939    1.0408    0.0306  200; ...
%                 1.6120    1.1862    1.0338    0.0249  300; ... 
%                 1.6102    1.1525    1.0261    0.0187  500; ...
%                1.55       1.1031       1.0178     0.012663  1000];

        re = 3/(4* sqrt(rho_0));  data.re = re;
        sde = 0.272249/( sqrt(data.nNN*rho_0));  data.sde = sde;
        c = (ra - re)/sde;   data.c = c;
        r = ra/re;           data.r = r;

    elseif (data.setkvalue == 2)

         NNbias_flat_k_2= dlmread('skdata\NNbias_flat_k_2.dat');
        store =  NNbias_flat_k_2(:, [4, 5, 2, 3, 1]); 
         % Store for Scavenged Poisson NN, k = 2
%       store = [  2.7434       1.8609        1.269      0.18243           10; ...
%                2.6375       1.4453        1.144     0.078935           30; ...
%                2.5356       1.4476       1.1065      0.06082           50; ...
%                2.4224       1.3107       1.0716     0.038743          100; ...
%                2.3993        1.194         1.05     0.024894          200; ...
%                2.3637       1.2214       1.0402     0.020774          300; ...
%                2.3169       1.2321       1.0305     0.016221          500; ...
%                2.3382       1.1721       1.0218     0.010906         1000];

         
        re = 15/(16* sqrt(rho_0));  data.re = re;
        sde = 0.275723/( sqrt(data.NN*rho_0));  data.sde = sde;
        c = (ra - re)/sde;   data.c = c;
        r = ra/re;           data.r = r;
    end
    

end

    
% Plot confidence limits on R 
set(gcbf,'CurrentAxes',findobj(gcbf,'Tag','Axes7'));    % move to the correct axes
cla reset

Xr = reshape(repmat(store(:,5), 1,2)', length(store)*2,1);
Yr = reshape(repmat(store(:,4), 1,2)', length(store)*2,1);
Y2r = reshape(repmat(store(:,4)*2, 1,2)', length(store)*2,1); % 2 sigma limits
R = reshape(repmat(store(:,3), 1,2)', length(store)*2,1);

hold on
%patchthreshclip = interp1([store(:,5); 10000], [store(:,4); 0],data.nNN+100,'linear');
%Rthreshclip = interp1([store(:,5); 10000], [store(:,3); 1],data.nNN+100,'linear');
patchthreshclip = interp1(store(:,5), store(:,4),data.nNN+100,'linear');
Rthreshclip = interp1(store(:,5), store(:,3),data.nNN+100,'linear');
rows = find(Xr < data.nNN+100);
Xrclip = [Xr(rows) ; data.nNN + 100; data.nNN + 100;10]; 
Yrclip = [Yr(rows) ; patchthreshclip; 0 ; 0];
Y2rclip = [Y2r(rows) ; patchthreshclip*2; 0 ; 0];
Rclip = [R(rows); Rthreshclip; 1; 1];

patch(Xrclip,  Y2rclip+Rclip, [0.7 0.7 0.7], 'EdgeColor', 'none', 'Clipping', 'On')
patch(Xrclip, -Y2rclip+Rclip, [0.7 0.7 0.7], 'EdgeColor', 'none', 'Clipping', 'On')
patch(Xrclip,   Yrclip+Rclip, [0.4 0.4 0.4], 'EdgeColor', 'none', 'Clipping', 'On')
patch(Xrclip, - Yrclip+Rclip, [0.4 0.4 0.4], 'EdgeColor', 'none', 'Clipping', 'On')
plot([store(:,5); 10000], [store(:,3); 1], 'k', 'LineWidth', 1)

plot(data.nNN, r, 'd', 'MarkerSize', 8, 'MarkerFaceColor', 'r')
axis([10 data.nNN+100 0.5-abs(r) 2+abs(r)])
set(gca,'Tag','Axes7');
set(gcbf,'Userdata',data)

% C
set(gcbf,'CurrentAxes',findobj(gcbf,'Tag','Axes8'));    % move to the correct axes
cla reset

Xc = reshape(repmat(store(:,5), 1,2)', length(store)*2,1);
Yc = reshape(repmat(store(:,2), 1,2)', length(store)*2,1);
Y2c = reshape(repmat(store(:,2)*2, 1,2)', length(store)*2,1); % 2 sigma limits
C = reshape(repmat(store(:,1), 1,2)', length(store)*2,1);

%patchthreshclip = interp1([store(:,5); 10000], [store(:,2); 1],data.nNN+100,'linear');
%Cthreshclip = interp1([store(:,5); 10000], [store(:,1); 0],data.nNN+100,'linear');
patchthreshclip = interp1(store(:,5), store(:,4),data.nNN+100,'linear');
Cthreshclip = interp1(store(:,5), store(:,3),data.nNN+100,'linear');
rows = find(Xc < data.nNN+100);
Xcclip = [Xc(rows) ; data.nNN + 100; data.nNN + 100;10]; 
Ycclip = [Yc(rows) ; patchthreshclip; 0 ; 0];
Y2cclip = [Y2c(rows) ; patchthreshclip*2; 0 ; 0];
Cclip = [C(rows); Cthreshclip; 0; 0];


hold on
patch(Xcclip, Y2cclip + Cclip, [0.7 0.7 0.7], 'EdgeColor', 'none')
patch(Xcclip, -Y2cclip + Cclip, [0.7 0.7 0.7], 'EdgeColor', 'none')
patch(Xcclip, Ycclip + Cclip, [0.4 0.4 0.4], 'EdgeColor', 'none')
patch(Xcclip, -Ycclip + Cclip, [0.4 0.4 0.4], 'EdgeColor', 'none')
plot([store(:,5); 10000], [store(:,1); 0], 'k', 'LineWidth', 1)

plot(data.nNN, c, 'd', 'MarkerSize', 8, 'MarkerFaceColor', 'r')
axis([10 data.nNN+100 -2-abs(c) 4+abs(c)])
set(gca,'Tag','Axes8');
set(gcbf,'Userdata',data)


% R and C statistics
set(findobj(gcbf,'Tag','CstatisticOut'),'String',num2str(data.c, '%5.3f'));
set(findobj(gcbf,'Tag','RstatisticOut'),'String',num2str(data.r, '%5.3f'));

% Interpolate to find an approximate limit

if data.NN > 9    
        data.cthreshneg1 = interp1([store(:,5); 100001], [store(:,1)-1*store(:,2); -2],data.nNN,'linear');
        data.cthreshneg2 = interp1([store(:,5); 100001], [store(:,1)-2*store(:,2); -2],data.nNN,'linear');
        set(findobj(gcbf,'Tag','CThresholdOutNeg1s'),'String',num2str(data.cthreshneg1, '%5.3f'));
        set(findobj(gcbf,'Tag','CThresholdOutNeg2s'),'String',num2str(data.cthreshneg2, '%5.3f'));
        data.cthreshpos1 = interp1([store(:,5); 100001], [store(:,1)+1*store(:,2); 2],data.nNN,'linear');
        data.cthreshpos2 = interp1([store(:,5); 100001], [store(:,1)+2*store(:,2); 2],data.nNN,'linear');
        set(findobj(gcbf,'Tag','CThresholdOutPos1s'),'String',num2str(data.cthreshpos1, '%5.3f')); 
        set(findobj(gcbf,'Tag','CThresholdOutPos2s'),'String',num2str(data.cthreshpos2, '%5.3f'));
        
        data.rthreshneg1 = interp1([store(:,5); 100001], [store(:,3)-1*store(:,4); 1],data.nNN,'linear');
        data.rthreshneg2 = interp1([store(:,5); 100001], [store(:,3)-2*store(:,4); 1],data.nNN,'linear');
        set(findobj(gcbf,'Tag','RThresholdOutNeg1s'),'String',num2str(data.rthreshneg1, '%5.3f'));
        set(findobj(gcbf,'Tag','RThresholdOutNeg2s'),'String',num2str(data.rthreshneg2, '%5.3f'));
        data.rthreshpos1 = interp1([store(:,5); 100001], [store(:,3)+1*store(:,4); 1],data.nNN,'linear');
        data.rthreshpos2 = interp1([store(:,5); 100001], [store(:,3)+2*store(:,4); 1],data.nNN,'linear');
        set(findobj(gcbf,'Tag','RThresholdOutPos1s'),'String',num2str(data.rthreshpos1, '%5.3f'));
        set(findobj(gcbf,'Tag','RThresholdOutPos2s'),'String',num2str(data.rthreshpos2, '%5.3f'));
else
    set(findobj(gcbf,'Tag','CThresholdOutPos'),'String','-');
    set(findobj(gcbf,'Tag','RThresholdOutPos'),'String','-');
end


if  (data.r < data.rthreshneg2)
    set(findobj(gcbf,'Tag','ImplicationR'),'String','Clustered (R < -2std)');
elseif (data.r > data.rthreshneg2) &&  (data.r < data.rthreshneg1)
    set(findobj(gcbf,'Tag','ImplicationR'),'String','Random (-2std < R < -1std)');
elseif (data.r > data.rthreshneg1) &&  (data.r < data.rthreshpos1)
    set(findobj(gcbf,'Tag','ImplicationR'),'String','Random (-1std < R < +1std)');
elseif (data.r > data.rthreshpos1) &&  (data.r < data.rthreshpos2)
    set(findobj(gcbf,'Tag','ImplicationR'),'String','Random (+1std < R < +2std)');
elseif (data.r > data.rthreshpos2)
    set(findobj(gcbf,'Tag','ImplicationR'),'String','Uniform (R > +2td)');
else
    set(findobj(gcbf,'Tag','ImplicationR'),'String','Unknown outcome');
end

if (data.r > data.rthreshneg2) &&  (data.r < data.rthreshpos2)
    if  (data.c < data.cthreshneg2)
        set(findobj(gcbf,'Tag','ImplicationC'),'String','Not Significant (c < -2std)');
    elseif (data.c > data.cthreshneg2) &&  (data.c < data.cthreshneg1)
        set(findobj(gcbf,'Tag','ImplicationC'),'String','Significant (-2std < c < -1std)');
    elseif (data.c > data.cthreshneg1) &&  (data.c < data.cthreshpos1)
        set(findobj(gcbf,'Tag','ImplicationC'),'String','Significant (-1std < c < +1std)');
    elseif (data.c > data.cthreshpos1) &&  (data.c < data.cthreshpos2)
        set(findobj(gcbf,'Tag','ImplicationC'),'String','Significant (+1std < c < +2std)');
    elseif (data.c > data.cthreshpos2)
        set(findobj(gcbf,'Tag','ImplicationC'),'String','Not significant (c > +2std)');
    end
else 
    set(findobj(gcbf,'Tag','ImplicationC'),'String','Not applicable');
end


% Ideal values of R and C
data.idealc = interp1([store(:,5); 100001], [store(:,1); 0],data.nNN,'linear');
data.idealr = interp1([store(:,5); 100001], [store(:,3); 1],data.nNN,'linear');