function data = PlotNNSkewvsKurtosis(data)

% Function to produce the plot for the skew vs kurtosis for the nearest
% neighbour distances

% Author: Ciaran Beggan
% Created: 21-03-2008
% Last Modified: 21-03-2008

% Version 0.1: Initial script produce plot and draw
%              onto the relevant axes

set(gcbf,'CurrentAxes',findobj(gcbf,'Tag','Axes9'));     % move to the correct axes
cla reset;
hold on
colour90 = [0.3 0.3 0.3];
colour95 = [0.7 0.7 0.7];
colour99 = [0.9 0.9 0.9];

% Add in circles of 'trust'!
if data.NN <= 40
    % % For 30 data
    svk = dlmread('skdata/svk30_flat.dat');
    ix = svk(:,3);
    plot(svk(ix(1:900),1), svk(ix(1:900),2), '.', 'MarkerEdgeColor', colour90)
    plot(svk(ix(901:950),1), svk(ix(901:950),2), '.', 'MarkerEdgeColor', colour95)
    plot(svk(ix(951:990),1), svk(ix(951:990),2), '.', 'MarkerEdgeColor', colour99)
    
elseif data.NN > 40 && data.NN <= 90
    svk = dlmread('skdata/svk50_flat.dat');
    ix = svk(:,3);
    plot(svk(ix(1:900),1), svk(ix(1:900),2), '.', 'MarkerEdgeColor', colour90)
    plot(svk(ix(901:950),1), svk(ix(901:950),2), '.', 'MarkerEdgeColor', colour95)
    plot(svk(ix(951:990),1), svk(ix(951:990),2), '.', 'MarkerEdgeColor', colour99)

elseif data.NN > 90 && data.NN <= 200
    % % For 100 data
    svk = dlmread('skdata/svk100_flat.dat');
    ix = svk(:,3);
    plot(svk(ix(1:900),1), svk(ix(1:900),2), '.', 'MarkerEdgeColor', colour90)
    plot(svk(ix(901:950),1), svk(ix(901:950),2), '.', 'MarkerEdgeColor', colour95)
    plot(svk(ix(951:990),1), svk(ix(951:990),2), '.', 'MarkerEdgeColor', colour99)
elseif data.NN > 200 && data.NN <= 400
    % % For 100 data
    svk = dlmread('skdata/svk300_flat.dat');
    ix = svk(:,3);
    plot(svk(ix(1:900),1), svk(ix(1:900),2), '.', 'MarkerEdgeColor', colour90)
    plot(svk(ix(901:950),1), svk(ix(901:950),2), '.', 'MarkerEdgeColor', colour95)
    plot(svk(ix(951:990),1), svk(ix(951:990),2), '.', 'MarkerEdgeColor', colour99)
elseif data.NN > 400 && data.NN <= 900
    % % For 100 data
    svk = dlmread('skdata/svk500_flat.dat');
    ix = svk(:,3);
    plot(svk(ix(1:900),1), svk(ix(1:900),2), '.', 'MarkerEdgeColor', colour90)
    plot(svk(ix(901:950),1), svk(ix(901:950),2), '.', 'MarkerEdgeColor', colour95)
    plot(svk(ix(951:990),1), svk(ix(951:990),2), '.', 'MarkerEdgeColor', colour99)
else
    % % For 1000 data
    svk = dlmread('skdata/svk1000_flat.dat');
    ix = svk(:,3);
    plot(svk(ix(1:900),1), svk(ix(1:900),2), '.', 'MarkerEdgeColor', colour90)
    plot(svk(ix(901:950),1), svk(ix(901:950),2), '.', 'MarkerEdgeColor', colour95)
    plot(svk(ix(951:990),1), svk(ix(951:990),2), '.', 'MarkerEdgeColor', colour99)
end


plot(data.NNskew, data.NNkurt, 'dr', 'MarkerFaceColor', 'r', 'MarkerSize', 8)
%axis([-1 4 -5 20 ])

set(findobj(gcbf,'Tag','SkewstatisticOut'),'String',num2str(data.NNskew, '%5.3f'));
set(findobj(gcbf,'Tag','KurtosisstatisticOut'),'String',num2str(data.NNkurt, '%5.3f'));

set(gca, 'Tag', 'Axes9');

set(gcbf,'Userdata',data);
