function [data] = PlotPlanetPoissonNNHist_v01(data)

% Function to produce the plot for the Planetary nearest neighbour analysis GUI

% Author: Ciaran Beggan
% Created: 19-11-2010
% Last Modified: 19-11-2010

% Version 0.1: Initial script to process image, produce histogram and draw
%              onto the relevant axes

% Plot the Nearest Neighbour Distances histogram 
set(gcbf,'CurrentAxes',findobj(gcbf,'Tag','Axes16'));    % move to the correct axes
cla reset

%labelXUnit = get(findobj(gcbf,'Tag','NNPixelUnit'),'String');

minnn = min(data.distances);
maxnn = max(data.distances);
histtemp = data.distances;
if any(histtemp == 0); histtemp((histtemp == 0)) = 1; end

if (strcmp(data.PlanetNNBinSizeOption, 'Default'))
    
    num_bins = 12;

    x_spaces = floor(logspace(log10(min(histtemp)),log10(max(histtemp)), num_bins));
    n = histc(histtemp, x_spaces);
    
    if ~data.PlanetNNYMaxAxisOption && strcmp(data.PlanetNNYAxisOption,'Linear')
        hb = bar(n, 'FaceColor', 'r', 'EdgeColor', 'w');
        set(gca,'XTickLabel', x_spaces)
        set(gca,'YTickMode', 'auto', 'YScale', 'Linear')
    elseif data.PlanetNNYMaxAxisOption && strcmp(data.PlanetNNYAxisOption,'Linear')
        n(n > data.NNYAxisMaxSize) = data.NNYAxisMaxSize;
        hb = bar(n, 'FaceColor', 'r', 'EdgeColor', 'w');
        set(gca,'XTickLabel', x_spaces)
        set(gca, 'YLim', [0 data.NNYAxisMaxSize])
    elseif ~data.PlanetNNYMaxAxisOption && strcmp(data.PlanetNNYAxisOption,'Log')
        [hx, hy] = stairs(n);
        semilogy(hx, hy)
        plot(hx(1:2:end-1)+1/2, hy(1:2:end-1), 'r.', 'MarkerSize', 10)
        set(gca,'YTickMode', 'auto', 'YScale', 'Log')
        set(gca,'XTickLabel', x_spaces, 'Xtick', 1:num_bins)
    else
        n(n > data.PlanetNNYAxisMaxSize) = data.PlanetNNYAxisMaxSize;
        [hx, hy] = stairs(n);
        plot(hx(1:2:end-1)+1/2, hy(1:2:end-1), 'r.', 'MarkerSize', 10)        
        set(gca,'YTickMode', 'auto', 'YScale', 'Log')
        set(gca,'XTickLabel', x_spaces, 'Xtick', 1:num_bins)
        set(gca, 'YLim', [0 data.PlanetNNYAxisMaxSize])
    end  
    
    xlabel(strcat('Nearest Neighbor Distance (km)')), ylabel('Frequency')
    
elseif (strcmp(data.PlanetNNBinSizeOption, 'Custom'))
     if strcmp(data.PlanetNNXAxisOption, 'Default')
        cla reset
        bins = minnn:data.PlanetNNBinSize:maxnn;
        num_bins = length(bins);

        num_x_ticks = floor(num_bins/10);
        if (num_x_ticks == 0); num_x_ticks = 1; end

        x_spaces = floor(linspace((min(histtemp)),(max(histtemp)), num_bins));
        n = histc(histtemp, x_spaces);
        y_spaces = floor(linspace(min(n), max(n)+max(n)/20, num_bins));
        num_y_ticks = floor(max(y_spaces)/10);
        
        

        % Y-Axis settings

        if ~data.PlanetNNYMaxAxisOption && strcmp(data.PlanetNNYAxisOption,'Linear')
            bar(n)
            h = findobj(gca,'Type','patch');
            set(h,'FaceColor','r','EdgeColor','w')
            set(gca,'XTickLabel', x_spaces(1:num_x_ticks:num_bins), 'XTick', 1:num_x_ticks:num_bins )
            %set(gca, 'YScale', 'Linear', 'YTickLabel', y_spaces(1:num_x_ticks:num_bins), 'YTick', 1:num_y_ticks:max(y_spaces) )
            set(gca, 'FontSize', 8)
        elseif data.PlanetNNYMaxAxisOption && strcmp(data.PlanetNNYAxisOption,'Linear')
            n(n > data.PlanetNNYAxisMaxSize) = data.PlanetNNYAxisMaxSize;
            bar(n, 'FaceColor', 'r', 'EdgeColor', 'w');
            set(gca,'XTickLabel', x_spaces(1:num_x_ticks:num_bins), 'XTick', 1:num_x_ticks:num_bins )
            set(gca, 'YLim', [0 data.PlanetNNYAxisMaxSize])
        elseif ~data.PlanetNNYMaxAxisOption && strcmp(data.PlanetNNYAxisOption,'Log')
            [hx, hy] = stairs(n);
            plot(hx(1:2:end-1)+1/2, hy(1:2:end-1), 'r.', 'MarkerSize', 10)
            set(gca,'YTickMode', 'auto', 'YScale', 'Log')
            set(gca,'XTickLabel', x_spaces(1:num_x_ticks:num_bins), 'XTick', 1:num_x_ticks:num_bins )
        else
            n(n > data.PlanetNNYAxisMaxSize) = data.PlanetNNYAxisMaxSize;
            [hx, hy] = stairs(n);
            plot(hx(1:2:end-1)+1/2, hy(1:2:end-1), 'r.', 'MarkerSize', 10)
            set(gca,'YTickMode', 'auto', 'YScale', 'Log')
            set(gca,'XTickLabel', x_spaces(1:num_x_ticks:num_bins), 'XTick', 1:num_x_ticks:num_bins )
            set(gca, 'YLim', [0 data.PlanetNNYAxisMaxSize])
        end


        xlabel(strcat('Nearest Neighbor Distance (km)')), ylabel('Frequency')

        % Custom X Axis
    elseif strcmp(data.PlanetNNXAxisOption , 'Custom')
        minsize = data.PlanetNNXAxisMinSize;
        maxsize = data.PlanetNNXAxisMaxSize;
        histtemp = histtemp(histtemp > minsize);
        histtemp = histtemp(histtemp < maxsize);
        bins = minsize:data.PlanetNNBinSize:maxsize;
        num_bins = length(bins);
        num_x_ticks = floor(num_bins/10);
        if num_x_ticks < 12
            num_x_ticks  = 6;
        end
        x_spaces = floor(linspace((min(histtemp)),(max(histtemp)), num_bins));
        n = histc(histtemp, x_spaces);
        y_spaces = floor(linspace(min(n), max(n)+max(n)/20, num_bins));
       
        % Custom Y Axis
        % Y-Axis settings

        if ~data.PlanetNNYMaxAxisOption && strcmp(data.PlanetNNYAxisOption,'Linear')
            bar(n)
            h = findobj(gca,'Type','patch');
            set(h,'FaceColor','r','EdgeColor','w')
            set(gca,'XTickLabel', x_spaces(1:num_x_ticks:num_bins), 'XTick', 1:num_x_ticks:num_bins )
            set(gca, 'YScale', 'Linear', 'YTickMode', 'auto')
            set(gca, 'FontSize', 8)
            %axis([minsize maxsize 0 max(n)+max(n)/20])
        elseif data.PlanetNNYMaxAxisOption && strcmp(data.PlanetNNYAxisOption,'Linear')
            n(n > data.PlanetNNYAxisMaxSize) = data.PlanetNNYAxisMaxSize;
            bar(n, 'FaceColor', 'r', 'EdgeColor', 'w');
            set(gca,'XTickLabel', x_spaces(1:num_x_ticks:num_bins), 'XTick', 1:num_x_ticks:num_bins )
            set(gca, 'YLim', [0 data.PlanetNNYAxisMaxSize])
        elseif ~data.PlanetNNYMaxAxisOption && strcmp(data.PlanetNNYAxisOption,'Log')
            [hx, hy] = stairs(n);
            plot(hx(1:2:end-1)+1/2, hy(1:2:end-1), 'r.', 'MarkerSize', 10) 
            set(gca,'YTickMode', 'auto', 'YScale', 'Log')
            set(gca,'XTickLabel', x_spaces(1:num_x_ticks:num_bins), 'XTick', 1:num_x_ticks:num_bins )
        else
            n(n > data.PlanetNNYAxisMaxSize) = data.PlanetNNYAxisMaxSize;
            [hx, hy] = stairs(n);
            plot(hx(1:2:end-1)+1/2, hy(1:2:end-1), 'r.', 'MarkerSize', 10) 
            set(gca,'YTickMode', 'auto', 'YScale', 'Log')
            set(gca,'XTickLabel', x_spaces(1:num_x_ticks:num_bins), 'XTick', 1:num_x_ticks:num_bins )
        end
        xlabel(strcat('Nearest Neighbor Distance (km)')), ylabel('Frequency')
        
    end

end

set(gca,'Tag','Axes16');
set(gcbf,'Userdata',data);