function data = SavePlanetNNRandCgraphs(data)

% Function to save to file the R and C graphs for the Nearest Neightbour statistic summary
% for Tab 3

% Author: Ciaran Beggan
% Created: 25-11-2011
% Last Modified: 25-11-2011


% Version 0.1: Based on PlotPlanetNNRandCgraphs

% Note: the data generated here comes from a script I wrote called Baloga
% simulations which derives these values from 1000 simulations of a Poisson
% distributed image

% store = [mean(C) std(C) mean(R) std(R) N]

OutputRjpgfilename_nn = [fullfile(data.pathname_outfile,data.outfile) 'PlanetNearestNeighborRplot.jpg'];
OutputCjpgfilename_nn = [fullfile(data.pathname_outfile,data.outfile) 'PlanetNearestNeighborCplot.jpg'];
% R image
% C image
%h1 = figure('Visible', 'off'); image(im), axis equal, box off, axis off, print(h1,'-djpeg', OutputCjpgfilename_nn), close(h1);



pixsize = 1;
stat = data.distances*pixsize;
data.nNN = length(stat);
ra = mean(stat);

% Load the correct store of bias curves for Poisson NN

if  strcmp(data.PlanetDatasetSize, 'Whole')
    rho_0 = data.NN/(ellarea(data.PlanetRadius(1),data.PlanetRadius(2)));
    NNbias_fullsphere_k_0 = dlmread('skdata\NNbias_fullsphere_k_0.dat');
    store =  NNbias_fullsphere_k_0(:, [4, 5, 2, 3, 1]);
elseif strcmp(data.PlanetDatasetSize, 'Half')
    NNbias_halfsphere_k_0 = dlmread('skdata\NNbias_halfsphere_k_0.dat');
    store =  NNbias_halfsphere_k_0(:, [4, 5, 2, 3, 1]);
    rho_0 = data.NN/(ellarea(data.PlanetRadius(1),data.PlanetRadius(2))/2);
elseif  strcmp(data.PlanetDatasetSize, 'Third')
    NNbias_thirdsphere_k_0 = dlmread('skdata\NNbias_thirdsphere_k_0.dat');
    store =  NNbias_thirdsphere_k_0(:, [4, 5, 2, 3, 1]);
    rho_0 = data.NN/(ellarea(data.PlanetRadius(1),data.PlanetRadius(2))/3);
elseif strcmp(data.PlanetDatasetSize, 'Quarter')
    NNbias_quartersphere_k_0 = dlmread('skdata\NNbias_quartersphere_k_0.dat');
    store =  NNbias_quartersphere_k_0(:, [4, 5, 2, 3, 1]);
    rho_0 = data.NN/(ellarea(data.PlanetRadius(1),data.PlanetRadius(2))/4);
else
    NNbias_flat_k_0 = dlmread('skdata\NNbias_flat_k_0.dat');
    store =  NNbias_flat_k_0(:, [4, 5, 2, 3, 1]);
    rho_0 = data.NN/(data.chull_area*pixsize^2);
end



% Calculate R and C

re = 1/(2* sqrt(rho_0));  data.re = re;
sde = 0.26136/( sqrt(data.nNN*rho_0));  data.sde = sde;
c = (ra - re)/sde;   data.c = c;
r = ra/re;           data.r = r;


% Plot confidence limits on R
h1 = figure('Visible', 'off', 'Position', [150 100 550 300], 'PaperPositionMode', 'auto');   % move to the correct axes
cla

Xr = reshape(repmat(store(:,5), 1,2)', length(store)*2,1);
Yr = reshape(repmat(store(:,4), 1,2)', length(store)*2,1);
Y2r = reshape(repmat(store(:,4)*2, 1,2)', length(store)*2,1); % 2 sigma limits
R = reshape(repmat(store(:,3), 1,2)', length(store)*2,1);

hold on
patchthreshclip = interp1(store(:,5), store(:,4),data.nNN+100,'linear');
Rthreshclip = interp1(store(:,5), store(:,3),data.nNN+100,'linear');
rows = find(Xr < data.nNN+100);
Xrclip = [Xr(rows) ; data.nNN + 100; data.nNN + 100;10];
Yrclip = [Yr(rows) ; patchthreshclip; 0 ; 0];
Y2rclip = [Y2r(rows) ; patchthreshclip*2; 0 ; 0];
Rclip = [R(rows); Rthreshclip; 1; 1];

patch(Xrclip,  Y2rclip+Rclip, [0.7 0.7 0.7], 'EdgeColor', 'none', 'Clipping', 'On')
patch(Xrclip, -Y2rclip+Rclip, [0.7 0.7 0.7], 'EdgeColor', 'none', 'Clipping', 'On')
patch(Xrclip,   Yrclip+Rclip, [0.4 0.4 0.4], 'EdgeColor', 'none', 'Clipping', 'On')
patch(Xrclip, - Yrclip+Rclip, [0.4 0.4 0.4], 'EdgeColor', 'none', 'Clipping', 'On')
plot([store(:,5); 10000], [store(:,3); 1], 'k', 'LineWidth', 1)

plot(data.nNN, r, 'd', 'MarkerSize', 8, 'MarkerFaceColor', 'r')

xlim([10 data.nNN+100])

if  (data.r < data.rthreshneg2)
    title('R statistic: Clustered (R < -2std)');
elseif (data.r > data.rthreshneg2) &&  (data.r < data.rthreshneg1)
    title('R statistic: Random (-2std < R < -1std)');
elseif (data.r > data.rthreshneg1) &&  (data.r < data.rthreshpos1)
    title('R statistic: Random (-1std < R < +1std)');
elseif (data.r > data.rthreshpos1) &&  (data.r < data.rthreshpos2)
    title('R statistic: Random (+1std < R < +2std)');
elseif (data.r > data.rthreshpos2)
    title('R statistic: Uniform (R > +2td)');
else
    title('R statistic: Unknown outcome');
end

% Write data onto the axes
strin = ['R: ' num2str(r, '%5.3f')];
annotation('textbox', [ 0.74 0.85  0.2  0.06],'String', strin ,'FontSize',9, 'EdgeColor', 'none')

data.rthreshpos1 = interp1([store(:,5); 100001], [store(:,3)+1*store(:,4); 1],data.nNN,'linear');
strin = ['R Threshold (+1 sigma): ' num2str(data.rthreshpos1, '%5.3f')];
annotation('textbox', [ 0.522 0.75 0.37  0.06],'String', strin ,'FontSize',9, 'EdgeColor', 'none')
data.rthreshpos2 = interp1([store(:,5); 100001], [store(:,3)+2*store(:,4); 1],data.nNN,'linear');
strin = ['R Threshold (+2 sigma): ' num2str(data.rthreshpos2, '%5.3f')];
annotation('textbox', [ 0.522 0.80 0.37  0.06],'String', strin ,'FontSize',9, 'EdgeColor', 'none')

data.rthreshneg1 = interp1([store(:,5); 100001], [store(:,3)-1*store(:,4); 1],data.nNN,'linear');
strin = ['R Threshold (-1 sigma): ' num2str(data.rthreshneg1, '%5.3f')];
annotation('textbox', [ 0.522 0.19  0.37  0.06],'String', strin ,'FontSize',9, 'EdgeColor', 'none')
data.rthreshneg2 = interp1([store(:,5); 100001], [store(:,3)-2*store(:,4); 1],data.nNN,'linear');
strin = ['R Threshold (-2 sigma): ' num2str(data.rthreshneg2, '%5.3f')];
annotation('textbox', [ 0.522 0.14 0.37  0.06],'String', strin ,'FontSize',9, 'EdgeColor', 'none')

box on
print(h1,'-djpeg', OutputRjpgfilename_nn), close(h1);

% C
h1 = figure('Visible', 'off', 'Position', [150 100 550 300], 'PaperPositionMode', 'auto');   % move to the correct axes
cla

Xc = reshape(repmat(store(:,5), 1,2)', length(store)*2,1);
Yc = reshape(repmat(store(:,2), 1,2)', length(store)*2,1);
Y2c = reshape(repmat(store(:,2)*2, 1,2)', length(store)*2,1); % 2 sigma limits
C = reshape(repmat(store(:,1), 1,2)', length(store)*2,1);

patchthreshclip = interp1(store(:,5), store(:,4),data.nNN+100,'linear');
Cthreshclip = interp1(store(:,5), store(:,3),data.nNN+100,'linear');
rows = find(Xc < data.nNN+100);
Xcclip = [Xc(rows) ; data.nNN + 100; data.nNN + 100;10];
Ycclip = [Yc(rows) ; patchthreshclip; 0 ; 0];
Y2cclip = [Y2c(rows) ; patchthreshclip*2; 0 ; 0];
Cclip = [C(rows); Cthreshclip; 0; 0];


hold on
patch(Xcclip, Y2cclip + Cclip, [0.7 0.7 0.7], 'EdgeColor', 'none')
patch(Xcclip, -Y2cclip + Cclip, [0.7 0.7 0.7], 'EdgeColor', 'none')
patch(Xcclip, Ycclip + Cclip, [0.4 0.4 0.4], 'EdgeColor', 'none')
patch(Xcclip, -Ycclip + Cclip, [0.4 0.4 0.4], 'EdgeColor', 'none')
plot([store(:,5); 10000], [store(:,1); 0], 'k', 'LineWidth', 1)

plot(data.nNN, c, 'd', 'MarkerSize', 8, 'MarkerFaceColor', 'r')
axis([10 data.nNN+100 -2-abs(c) 4+abs(c)])

if  (data.c < data.cthreshneg2)
    title('C statistic: Not Significant (c < -2std)');
elseif (data.c > data.cthreshneg2) &&  (data.c < data.cthreshneg1)
     title('C statistic: Significant (-2std < c < -1std)');
elseif (data.c > data.cthreshneg1) &&  (data.c < data.cthreshpos1)
     title('C statistic: Significant (-1std < c < +1std)');
elseif (data.c > data.cthreshpos1) &&  (data.c < data.cthreshpos2)
     title('C statistic: Significant (+1std < c < +2std)');
elseif (data.c > data.cthreshpos2)
     title('C statistic: Not significant (c > +2std)');
else
     title('C statistic: Unknown outcome');
end

% Interpolate to find an approximate limit

data.cthreshneg2 = interp1([store(:,5); 100001], [store(:,1)-2*store(:,2); -2],data.nNN,'linear');
data.cthreshpos1 = interp1([store(:,5); 100001], [store(:,1)+1*store(:,2); 2],data.nNN,'linear');
data.cthreshpos2 = interp1([store(:,5); 100001], [store(:,1)+2*store(:,2); 2],data.nNN,'linear');


% Write data onto the axes
strin = ['C: ' num2str(c, '%5.3f')];
annotation('textbox', [ 0.74 0.85  0.2  0.06],'String', strin ,'FontSize',9, 'EdgeColor', 'none')

strin = ['C Threshold (+1 sigma): ' num2str(data.cthreshpos1, '%5.3f')];
annotation('textbox', [ 0.522 0.75 0.37  0.06],'String', strin ,'FontSize',9, 'EdgeColor', 'none')
data.rthreshpos2 = interp1([store(:,5); 100001], [store(:,3)+2*store(:,4); 1],data.nNN,'linear');
strin = ['C Threshold (+2 sigma): ' num2str(data.cthreshpos2, '%5.3f')];
annotation('textbox', [ 0.522 0.80 0.37  0.06],'String', strin ,'FontSize',9, 'EdgeColor', 'none')

data.rthreshneg1 = interp1([store(:,5); 100001], [store(:,3)-1*store(:,4); 1],data.nNN,'linear');
strin = ['C Threshold (-1 sigma): ' num2str(data.cthreshneg1, '%5.3f')];
annotation('textbox', [ 0.522 0.19  0.37  0.06],'String', strin ,'FontSize',9, 'EdgeColor', 'none')
data.rthreshneg2 = interp1([store(:,5); 100001], [store(:,3)-2*store(:,4); 1],data.nNN,'linear');
strin = ['C Threshold (-2 sigma): ' num2str(data.cthreshneg2, '%5.3f')];
annotation('textbox', [ 0.522 0.14 0.37  0.06],'String', strin ,'FontSize',9, 'EdgeColor', 'none')


box on
print(h1,'-djpeg', OutputCjpgfilename_nn), close(h1);



