function Tab_ImageAnalysis(htab,evdt,hpanel,hstatus, colortab, colo)

% % Model selection 
          uicontrol('Parent',hpanel(1), 'Style','text', ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','center', ...
            'Position',[0.787 0.95 0.15 0.035], ...
            'FontWeight', 'bold',...
            'String','Statistical Summary');
        
        rh5 = uibuttongroup('Parent',hpanel(1), ...
            'BackgroundColor',colo, ...
            'visible','on', ...
            'Position',[0.681 0.589 .3 0.36], ...
            'Units','normalized');
        set(rh5,'SelectionChangeFcn','gias_guifun_v06 setStatSummary' );
        % Create radio buttons in the button group.
         uicontrol('Style','Radio','String','Object Area',...
            'Units','normalized', 'FontSize',10,'BackgroundColor',colo,...
            'pos',[0.03 0.83 0.31 .11],'parent',rh5, 'Tag', 'StatArea');
        uicontrol('Style','Radio','String','Perimeter',...
            'Units','normalized','FontSize',10, 'BackgroundColor',colo,...
            'pos',[0.03 0.68 0.31 .11],'parent',rh5,'Tag', 'StatPerimeter');
        uicontrol('Style','Radio','String','Eccentricity',...
            'Units','normalized', 'FontSize',10,'BackgroundColor',colo, ...
            'pos',[0.36 0.83 0.31 .11],'parent',rh5,'Tag', 'StatEccentricity');
        uicontrol('Style','Radio','String','Orientation',...
            'Units','normalized','FontSize',10, 'BackgroundColor',colo, ...
            'pos',[0.36 0.68 0.31 .11],'parent',rh5,'Tag', 'StatOrientation');

         % Percentage Vesicularity
        uicontrol('Parent',rh5, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','center', ...
            'Position',[0.68 0.83 0.31 .10], ...
            'String','Abundance (%)', ...
            'TooltipString','The percentage of black versus white pixels in the image',...
            'Style','text');

        uicontrol('Parent',rh5,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.74 0.72 0.15 0.1], ...
            'String','', ...
            'Style','text', ...
            'Tag','StatPercentVesiclesOut', ...
            'TooltipString','The percentage of black versus white pixels in the image');
        
        % Number of Objects
        uicontrol('Parent',rh5, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.02 0.52 0.17 0.1], ...
            'String','Total #:', ...
            'Style','text');

        uicontrol('Parent',rh5,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.24 0.52 0.15 0.1], ...
            'String','', ...
            'Style','text', ...
            'Tag','StatNumBubblesOut', ...
            'TooltipString','Number of Objects detected');
        
        % Minimum
        uicontrol('Parent',rh5, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.025 0.37 0.2 0.1], ...
            'String','Minimum:', ...
            'Style','text');

        uicontrol('Parent',rh5,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.24 0.37 0.15 0.1], ...
            'String','', ...
            'Style','text', ...
            'Tag','StatMinimumOut');

        % Maximum
        uicontrol('Parent',rh5, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.025 0.22 0.21 0.1], ...
            'String','Maximum:', ...
            'Style','text');

        uicontrol('Parent',rh5,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.24 0.22 0.15 0.1], ...
            'String','', ...
            'Style','text', ...
            'Tag','StatMaximumOut');
        
        % Mean
        uicontrol('Parent',rh5, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.05 0.07 0.17 0.1], ...
            'String','Mean:', ...
            'Style','text');

        uicontrol('Parent',rh5,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.24 0.07 0.15 0.1], ...
            'String','', ...
            'Style','text', ...
            'Tag','StatMeanOut');


        % Std
        uicontrol('Parent',rh5, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.55 0.52 0.17 0.1], ...
            'String','Stdev:', ...
            'Style','text');

        uicontrol('Parent',rh5,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.74 0.52 0.15 0.1], ...
            'String','', ...
            'Style','text', ...
            'Tag','StatStdOut');
        
        % Mode
        uicontrol('Parent',rh5, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.55 0.37 0.17 0.1], ...
            'String','Mode:', ...
            'Style','text');

        uicontrol('Parent',rh5,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.74 0.37 0.15 0.1], ...
            'String','', ...
            'Style','text', ...
            'Tag','StatModeOut');

        % Skewness
        uicontrol('Parent',rh5, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.52 0.22 0.2 0.1], ...
            'String','Skewness:', ...
            'Style','text');

        uicontrol('Parent',rh5,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.74 0.22 0.15 0.1], ...
            'String','', ...
            'Style','text', ...
            'Tag','StatSkewnessOut');
        
        % Kurtosis
        uicontrol('Parent',rh5, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.55 0.07 0.17 0.1], ...
            'String','Kurtosis:', ...
            'Style','text');

        uicontrol('Parent',rh5,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.74 0.07 0.15 0.1], ...
            'String','', ...
            'Style','text', ...
            'Tag','StatKurtosisOut');
        
        
%        Processed images ------------------------------------
        % Radio buttons menu for the  histogram plot
        
        % % Bin size
          uicontrol('Parent',hpanel(1), 'Style','text', ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','center', ...
            'Position',[0.02 0.139 0.062 0.035], ...
            'String','Bin Size:');
        rh6 = uibuttongroup('Parent',hpanel(1), ...
            'BackgroundColor',colo, ...
            'visible','on', ...
            'Position',[0.085 0.133 .13 0.05], ...
            'Units','normalized');
        set(rh6,'SelectionChangeFcn','gias_guifun_v06 setBubSizePhiCustom' );
        % Create radio buttons in the button group.
         uicontrol('Style','Radio','String','Default',...
            'Units','normalized', 'FontSize',10,'BackgroundColor',colo,...
            'Tag', 'Default scale', ...
            'pos',[0.03 0.1 0.405 .75],'parent',rh6, 'Tag', 'BubSizePhi');  % Changed to Default from Log 2 (Date:01-07-08)
         uicontrol('Style','Radio','String','Custom',...
            'Units','normalized','FontSize',10, 'BackgroundColor',colo,...
            'pos',[0.484 0.1 0.495 .75],'parent',rh6, 'Tag', 'BubSizeCustom');
        % Input box for Bin size
        uicontrol('Parent',hpanel(1), ...
            'Units','normalized', ...
            'Callback','gias_guifun_v06 setBubSizePhiCustom', ...
            'BackgroundColor',[0.3 0.6 0.2], ...
            'FontSize',10, ...
            'ForegroundColor', [1 1 1], ...
            'Position', [0.22 0.134 0.035 0.04], ...
            'String','500', ...
            'Style','edit', ...
            'Tag','setBubSizeCustomBin', ...
            'TooltipString','Enter Bin Width');
        % mm label
        uicontrol('Parent',hpanel(1), ...
            'Units','normalized', ...
            'Position',[0.26 0.139 0.035 0.025], ...
            'BackgroundColor',colortab, ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Style', 'text', ...
            'Tag', 'IAPixelUnit', ...
            'String',' mm');

        
        % % X Axis
          uicontrol('Parent',hpanel(1), 'Style','text', ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','center', ...
            'Position',[0.02 0.089 0.062 0.035], ...
            'String','X Axis:');
        rh7 = uibuttongroup('Parent',hpanel(1), ...
            'BackgroundColor',colo, ...
            'visible','on', ...
            'Position',[0.085 0.083 .13 0.05], ...
            'Units','normalized');
        set(rh7,'SelectionChangeFcn','gias_guifun_v06 setBubSizeXCustom' );
        % Create radio buttons in the button group.
         uicontrol('Style','Radio','String','Default',...
            'Units','normalized', 'FontSize',10,'BackgroundColor',colo,...
            'pos',[0.03 0.1 0.405 .75],'parent',rh7,'Tag', 'BubXSizeDefault');
         uicontrol('Style','Radio','String','Custom',...
            'Units','normalized','FontSize',10, 'BackgroundColor',colo,...
            'pos',[0.484 0.1 0.495 .75],'parent',rh7,'Tag', 'BubXSizeCustom');
        % Input box for X axis minimum size
        uicontrol('Parent',hpanel(1), ...
            'Units','normalized', ...
            'Callback','gias_guifun_v06 setBubSizeXCustom', ...
            'BackgroundColor',[0.3 0.6 0.2], ...
            'FontSize',10, ...
            'ForegroundColor', [1 1 1], ...
            'Position', [0.22 0.089 0.035 0.04], ...
            'String','Min', ...
            'Style','edit', ...
            'Tag','setBubXAxisMinSize', ...
            'TooltipString','Enter miniumum Bin Size');
        % mm label
        uicontrol('Parent',hpanel(1), ...
            'Units','normalized', ...
            'Position',[0.26 0.1 0.035 0.025], ...
            'BackgroundColor',colortab, ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Style', 'text', ...
            'Tag', 'IAPixelUnit', ...
            'String',' mm');
       % Input box for X axis maximum size
        uicontrol('Parent',hpanel(1), ...
            'Units','normalized', ...
            'Callback','gias_guifun_v06 setBubSizeXCustom', ...
            'BackgroundColor',[0.3 0.6 0.2], ...
            'FontSize',10, ...
            'ForegroundColor', [1 1 1], ...
            'Position', [0.29 0.089 0.035 0.04], ...
            'String','Max', ...
            'Style','edit', ...
            'Tag','setBubXAxisMaxSize', ...
            'TooltipString','Enter maxiumum Bin Size');
        % mm label
        uicontrol('Parent',hpanel(1), ...
            'Units','normalized', ...
            'Position',[0.33 0.1 0.035 0.025], ...
            'BackgroundColor',colortab, ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Style', 'text', ...
            'Tag', 'IAPixelUnit', ...
            'String',' mm');
        
        
        % % Y Axis
          uicontrol('Parent',hpanel(1), 'Style','text', ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','center', ...
            'Position',[0.02 0.039 0.042 0.035], ...
            'String','Y Axis:');
        rh8 = uibuttongroup('Parent',hpanel(1), ...
            'BackgroundColor',colo, ...
            'visible','on', ...
            'Position',[0.085 0.033 .13 0.05], ...
            'Units','normalized');  
        set(rh8,'SelectionChangeFcn','gias_guifun_v06 setBubSizeYLinLog' );
        % Create radio buttons in the button group.
        uicontrol('Style','Radio','String','Linear',...
            'Units','normalized', 'FontSize',10,'BackgroundColor',colo,...
            'pos',[0.03 0.1 0.405 .75],'parent',rh8,'Tag', 'BubYSizeLinear');
         uicontrol('Style','Radio','String','Log',...
            'Units','normalized','FontSize',10, 'BackgroundColor',colo,...
            'pos',[0.484 0.1 0.495 .75],'parent',rh8,'Tag', 'BubYSizeLog');
                  uicontrol('Parent',hpanel(1), 'Style','text', ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','center', ...
            'Position',[0.02 0.039 0.062 0.035], ...
            'String','Y Axis:');

        % Maximum Value for the Y Axis
        rh81 = uibuttongroup('Parent',hpanel(1), ...
            'BackgroundColor',colo, ...
            'visible','on', ...
            'Position',[0.22 0.033 .065 0.05], ...
            'Units','normalized');  
        set(rh81,'SelectionChangeFcn','gias_guifun_v06 setYAxisMaxSize' );

         uicontrol('Style','checkbox','String','Custom','Value', 0, ...
            'Units','normalized','FontSize',10, 'BackgroundColor',colo,...
            'pos',[0.05 0.05 0.85 .85],'parent',rh81, 'Tag', 'BubSizeYAxisMax');
       % Input box for Y axis maximum size
        uicontrol('Parent',hpanel(1), ...
            'Units','normalized', ...
            'Callback','gias_guifun_v06 setYAxisMaxSize', ...
            'BackgroundColor',[0.3 0.6 0.2], ...
            'FontSize',10, ...
            'ForegroundColor', [1 1 1], ...
            'Position', [0.29 0.035 0.035 0.04], ...
            'String','Max', ...
            'Style','edit', ...
            'Tag','YAxisMaxSizeValue', ...
            'TooltipString','Enter maxiumum frequency');

        % Histogram - bottom left - Bubble Size Distribution
        axes('Parent',hpanel(1), ...
            'Box','on', ...
            'Clipping', 'on', ...
            'Color',[1 1 1], ...
            'FontSize',8, ...
            'Position',[0.05 0.25 0.3 0.645], ...
            'Tag','Axes2', ...
            'NextPlot','replace', ...
            'XColor',[0 0 0], ...
            'XTickMode','manual', ...
            'YColor',[0 0 0], ...
            'YTickMode','manual', ...
            'ZColor',[0 0 0]);

        uicontrol('Parent',hpanel(1), ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, ...
            'FontWeight', 'bold',...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','center', ...
            'Position',[0.07 0.91 0.236 0.035], ...
            'String','Object Size-Frequency Distribution', ...
            'Style','text');

        % Bubble eccentricity plot - middle bottom
        axes('Parent',hpanel(1), ...
            'Box','on', ...
            'CameraUpVector',[0 1 0], ...
            'CameraUpVectorMode','manual', ...
            'Color',[1 1 1], ...
            'FontSize',8, ...
            'Position',[0.392 0.08 0.265 0.375], ...
            'Tag','Axes4', ...
            'NextPlot','add', ...
            'XColor',[0 0 0], ...
            'XTickMode','manual', ...
            'YColor',[0 0 0], ...
            'YTickMode','manual', ...
            'ZColor',[0 0 0]);

        uicontrol('Parent',hpanel(1), ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.388 0.46 0.15 0.045], ...
            'String','Object Eccentricity', ...
            'FontWeight', 'bold',...
            'Style','text', ...
            'TooltipString','');

        % Bubble perimeter - middle top
        axes('Parent',hpanel(1), ...
            'Box','on', ...
            'CameraUpVector',[0 1 0], ...
            'CameraUpVectorMode','manual', ...
            'Color',[1 1 1], ...
            'FontSize',8, ...
            'Position',[0.392 0.64 0.265 0.3], ...
            'Tag','Axes3', ...
            'NextPlot','add', ...
            'XColor',[0 0 0], ...
            'XTickMode','manual', ...
            'YColor',[0 0 0], ...
            'YTickMode','manual', ...
            'ZColor',[0 0 0]);

        uicontrol('Parent',hpanel(1), ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, ...
            'FontWeight', 'bold',...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.388 0.94 0.2 0.045], ...
            'String','Object Perimeters', ...
            'Style','text', ...
            'Tag','textRstatisticOut', ...
            'TooltipString','');
        
        rh4 = uibuttongroup('Parent',hpanel(1), ...
            'BackgroundColor',colortab, 'SelectionHighlight', 'off',...
            'visible','on', 'ShadowColor', colortab,...
            'Position',[0.381 0.52 .273 0.05], ...
            'Units','normalized');
        set(rh4,'SelectionChangeFcn','gias_guifun_v06 setAxes3' );
        % Create radio buttons in the button group.
         uicontrol('Style','Radio','String','Histogram',...
            'Units','normalized', 'FontSize',7,'BackgroundColor',colortab,...
            'pos',[0.01 0.1 0.21 .75],'parent',rh4, 'Tag', 'Axes3Histogram', 'TooltipString','Histogram of the Object Perimeter Length');
        uicontrol('Style','Radio','String','Perim. vs. Equal-Area Circ.',...
            'Units','normalized','FontSize',7, 'BackgroundColor',colortab,...
            'pos',[0.23 0.1 0.43 .75],'parent',rh4,'Tag', 'Axes3Plot', 'TooltipString','Graph of Object Perimeter Length versus the Perimeter of an equivalent Equal-Area Circle');
        uicontrol('Style','Radio','String','Equal-Area Circ. Rad.',...
            'Units','normalized','FontSize',7, 'BackgroundColor',colortab,...
            'pos',[0.665 0.1 0.331 .75],'parent',rh4,'Tag', 'Axes3RadiusPlot', 'TooltipString','Histogram of the Radius of an equivalent Equal-Area Circle');


        % Bubble orientation - right
        axes('Parent',hpanel(1), ...
            'Box','on', ...
            'CameraUpVector',[0 1 0], ...
            'CameraUpVectorMode','manual', ...
            'Color',[1 1 1], ...
            'FontSize',8, ...
            'Position',[0.68 0.03 0.3 0.49], ...
            'Tag','Axes5', ...
            'NextPlot','add', ...
            'XColor',[0 0 0], ...
            'XTickMode','manual', ...
            'YColor',[0 0 0], ...
            'YTickMode','manual', ...
            'ZColor',[0 0 0]);

        uicontrol('Parent',hpanel(1), ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','center', ...
            'Position',[0.757 0.53 0.132 0.04], ...
            'String','Object Orientations', ...
            'Style','text', ...
            'FontWeight', 'bold',...
            'TooltipString','');