function Tab_PlanetaryNN(htab,evdt,hpanel,hstatus, colortab, colo)

% Set the planetary radius


% C Statistics
        uicontrol('Parent',hpanel(3),...
            'Units','normalized', ...
            'BackgroundColor','w', ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.609 0.396 0.017 0.035], ...
            'String','C:', ...
            'Style','text');

        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor','w', ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.629 0.385 0.027 0.045], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetCstatisticOut', ...
            'TooltipString','C');
        
        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor','w', ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.629 0.372 0.027 0.022], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetCThresholdOutPos1s', ...
            'TooltipString','C Threshold Positive');

        
        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor','w', ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.629 0.348 0.027 0.022], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetCThresholdOutNeg1s', ...
            'TooltipString','C Threshold Negative');
        
        
                uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor','w', ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.629 0.103 0.027 0.022], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetCThresholdOutPos2s', ...
            'TooltipString','C Threshold Positive');

        
        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor','w', ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.629 0.079 0.027 0.022], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetCThresholdOutNeg2s', ...
            'TooltipString','C Threshold Negative');

        % R statistics
        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor','w', ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.609 0.884 0.017 0.03], ...
            'String','R:', ...
            'Style','text');

        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor','w', ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.627 0.867 0.027 0.045], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetRstatisticOut', ...
            'TooltipString','R');

        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor','w', ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.627 0.857 0.027 0.022], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetRThresholdOutPos1s', ...
            'TooltipString','R Threshold Positive');

        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor','w', ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.627 0.83 0.027 0.022], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetRThresholdOutNeg1s', ...
            'TooltipString','R Threshold Negative');
        
        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor','w', ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.627 0.59 0.027 0.022], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetRThresholdOutPos2s', ...
            'TooltipString','R Threshold Positive');

        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor','w', ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.627 0.563 0.027 0.022], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetRThresholdOutNeg2s', ...
            'TooltipString','R Threshold Negative');


   % % R and C curve selection based on size of planetary dataset
          uicontrol('Parent',hpanel(3), 'Style','text', ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','center', ...
            'FontWeight', 'bold',...
            'Position',[0.757 0.892 0.15 0.035], ...
            'String','Dataset Size');
        rh191 = uibuttongroup('Parent',hpanel(3), ...
            'BackgroundColor',colo, ...
            'visible','on', ...
            'Position',[0.687 0.83 .295 0.06], ...
            'Units','normalized');
        set(rh191,'SelectionChangeFcn','gias_guifun_v06 setPlanetDatasetSize' );
        % Create radio buttons in the button group.
         uicontrol('Style','Radio','String','Whole',...
            'Units','normalized', 'FontSize',10,'BackgroundColor',colo,...
            'pos',[0.03 0.03 0.2 .75],'parent',rh191,'Tag', 'WholePlanet', 'TooltipString','Use the whole planet area');
         uicontrol('Style','Radio','String','Half',...
            'Units','normalized','FontSize',10, 'BackgroundColor',colo,...
            'pos',[0.22 0.03 0.2 .75],'parent',rh191,'Tag', 'HalfPlanet', 'TooltipString','Use half the planet surface area');
         uicontrol('Style','Radio','String','Third',...
            'Units','normalized','FontSize',10, 'BackgroundColor',colo,...
            'pos',[0.38 0.03 0.2 .75],'parent',rh191,'Tag', 'ThirdPlanet', 'TooltipString','Use third the planet surface area');
        uicontrol('Style','Radio','String','Quarter',...
            'Units','normalized', 'FontSize',10,'BackgroundColor',colo, ...
            'pos',[0.55 0.03 0.2 .75],'parent',rh191,'Tag', 'QuarterPlanet', 'TooltipString','Use quarter the planet surface area');
        uicontrol('Style','Radio','String',' Region',...
            'Units','normalized', 'FontSize',10,'BackgroundColor',colo, ...
            'pos',[0.77 0.03 0.2 .75],'parent',rh191,'Tag', 'Region', 'TooltipString','Use the computed hulll area');        
        
        % Output NN Statistics
        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor', colortab, ...
            'FontSize',10, ...
            'FontWeight', 'bold',...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.752 0.715 0.22 0.045], ...
            'String','Nearest Neighbor Results (Ra)', ...
            'Style','text');

        rh110 = uipanel('Parent',hpanel(3), ...
            'BackgroundColor',colo, ...
            'visible','on', ...
            'Position',[0.68 0.434 .302 0.28], ...
            'Units','normalized');
        
        % Number of Bubbles
        uicontrol('Parent',rh110,...
            'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.02 0.8 0.17 0.11], ...
            'String','Total:', ...
            'Style','text');

        uicontrol('Parent',rh110,...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.21 0.8 0.15 0.11], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetNNNumBubblesOut', ...
            'TooltipString','Number of Objects detected');
        
        % Minimum
        uicontrol('Parent',rh110, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.015 0.57 0.195 0.11], ...
            'String','Minimum:', ...
            'Style','text');

        uicontrol('Parent',rh110,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.21 0.57 0.15 0.11], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetNNMinimumOut');

        % Maximum
        uicontrol('Parent',rh110, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.005 0.35 0.205 0.11], ...
            'String','Maximum:', ...
            'Style','text');

        uicontrol('Parent',rh110,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.21 0.35 0.15 0.11], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetNNMaximumOut');
        
        % Mean
        uicontrol('Parent',rh110, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.015 0.1 0.195 0.11], ...
            'String','Mean (Ra):', ...
            'Style','text');

        uicontrol('Parent',rh110,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.21 0.1 0.15 0.11], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetNNMeanOut');

        % Std
        uicontrol('Parent',rh110, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.372 0.8 0.197 0.11], ...
            'String','Std (data):', ...
            'Style','text');

        uicontrol('Parent',rh110,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.57 0.8 0.15 0.11], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetNNStdOut');
        
        % Skewness
        uicontrol('Parent',rh110, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.375 0.35 0.195 0.11], ...
            'String','Skewness:', ...
            'Style','text');

        uicontrol('Parent',rh110,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.57 0.35 0.15 0.11], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetNNSkewnessOut');
        
        % Kurtosis
        uicontrol('Parent',rh110, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.39 0.1 0.17 0.11], ...
            'String','Kurtosis:', ...
            'Style','text');

        uicontrol('Parent',rh110,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.57 0.1 0.15 0.11], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetNNKurtosisOut');

        % R expected
        uicontrol('Parent',rh110,...
            'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10, ...
            'ListboxTop',0, ...
            'FontWeight', 'bold',...
            'ForegroundColor',[1 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.74 0.8 0.1 0.11], ...
            'String','Re:', ...
            'Style','text')

        uicontrol('Parent',rh110,...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.85 0.8 0.14 0.11], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetNNReOut', ...
            'TooltipString','Expected Mean');
         % Std error (std_e
        uicontrol('Parent',rh110, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'FontWeight', 'bold',...
            'ForegroundColor',[1 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.74 0.57 0.1 0.11], ...
            'String','Std:', ...
            'Style','text');

        uicontrol('Parent',rh110,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.85 0.57 0.14 0.11], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetNNStd_eOut');

        % R ratio
        uicontrol('Parent',rh110, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[1 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.74 0.35 0.1 0.11], ...
            'String','R:', ...
            'FontWeight', 'bold',...
            'Style','text');

        uicontrol('Parent',rh110,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.85 0.35 0.14 0.11], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetNNROut');
        
        % C
        uicontrol('Parent',rh110, 'Units','normalized', ...
            'BackgroundColor',colo, ...
            'FontSize',10,'ListboxTop',0, ...
            'ForegroundColor',[1 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.74 0.1 0.1 0.11], ...
            'FontWeight', 'bold',...
            'String','C:', ...
            'Style','text');

        uicontrol('Parent',rh110,'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.85 0.1 0.14 0.11], ...
            'String','', ...
            'Style','text', ...
            'Tag','PlanetNNCOut');
        
 
        % % -------------------------------------------
        % Imagery Output


    % % ------------------- axes for Processed images ------------------------------------

        % Radio buttons menu for the NN histogram plot
        
        %% Bin size
          uicontrol('Parent',hpanel(3), 'Style','text', ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','center', ...
            'Position',[0.02 0.139 0.062 0.035], ...
            'String','Bin Size:');
        rh1 = uibuttongroup('Parent',hpanel(3), ...
            'BackgroundColor',colo, ...
            'visible','on', ...
            'Position',[0.085 0.133 .13 0.05], ...
            'Units','normalized');
        set(rh1,'SelectionChangeFcn','gias_guifun_v06 setPlanetNNSizeDefaultCustom' );
        % Create radio buttons in the button group.
        uicontrol('Style','Radio','String','Default',...
            'Units','normalized', 'FontSize',10,'BackgroundColor',colo,...
            'pos',[0.03 0.1 0.405 .75],'parent',rh1, 'Tag', 'PlanetNNSizeDefault');
         uicontrol('Style','Radio','String','Custom',...
            'Units','normalized','FontSize',10, 'BackgroundColor',colo,...
            'pos',[0.484 0.1 0.495 .75],'parent',rh1, 'Tag', 'PlanetNNSizeCustom');
        % Input box for Bin size
        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'Callback','gias_guifun_v06 setPlanetNNSizeDefaultCustom', ...
            'BackgroundColor',[0.3 0.6 0.2], ...
            'FontSize',10, ...
            'ForegroundColor', [1 1 1], ...
            'Position', [0.22 0.134 0.035 0.04], ...
            'String','5', ...
            'Style','edit', ...
            'Tag','setPlanetNNSizeCustomBin', ...
            'TooltipString','Enter Bin in km');
        % mm label
        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'Position',[0.26 0.139 0.035 0.025], ...
            'BackgroundColor',colortab, ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Style', 'text', ...
            'Tag', 'PlanetNNPixelUnit', ...
            'String',' km');

        
        % % X Axis
          uicontrol('Parent',hpanel(3), 'Style','text', ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','center', ...
            'Position',[0.02 0.089 0.062 0.035], ...
            'String','X Axis:');
        rh2 = uibuttongroup('Parent',hpanel(3), ...
            'BackgroundColor',colo, ...
            'visible','on', ...
            'Position',[0.085 0.083 .13 0.05], ...
            'Units','normalized');
        set(rh2,'SelectionChangeFcn','gias_guifun_v06 setPlanetNNSizeXCustom' );
        % Create radio buttons in the button group.
       uicontrol('Style','Radio','String','Default',...
            'Units','normalized', 'FontSize',10,'BackgroundColor',colo,...
            'pos',[0.03 0.1 0.405 .75],'parent',rh2,'Tag', 'PlanetNNXSizeDefault');
         uicontrol('Style','Radio','String','Custom',...
            'Units','normalized','FontSize',10, 'BackgroundColor',colo,...
            'pos',[0.484 0.1 0.495 .75],'parent',rh2,'Tag', 'PlanetNNXSizeCustom');
        % Input box for X axis minimum size
        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'Callback','gias_guifun_v06 setPlanetNNSizeXCustom', ...
            'BackgroundColor',[0.3 0.6 0.2], ...
            'FontSize',10, ...
            'ForegroundColor', [1 1 1], ...
            'Position', [0.22 0.089 0.035 0.04], ...
            'String','Min', ...
            'Style','edit', ...
            'Tag','setPlanetNNXAxisMinSize', ...
            'TooltipString','Enter miniumum in km');
        % mm label
        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'Position',[0.26 0.1 0.035 0.025], ...
            'BackgroundColor',colortab, ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Style', 'text', ...
            'Tag', 'PlanetNNPixelUnit', ...
            'String',' km');
       % Input box for X axis maximum size
        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'Callback','gias_guifun_v06 setPlanetNNSizeXCustom', ...
            'BackgroundColor',[0.3 0.6 0.2], ...
            'FontSize',10, ...
            'ForegroundColor', [1 1 1], ...
            'Position', [0.29 0.089 0.035 0.04], ...
            'String','Max', ...
            'Style','edit', ...
            'Tag','setPlanetNNXAxisMaxSize', ...
            'TooltipString','Enter maxiumum in km');
        % mm label
        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'Position',[0.33 0.1 0.035 0.025], ...
            'BackgroundColor',colortab, ...
            'FontSize',8, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','left', ...
            'Style', 'text', ...
            'Tag', 'PlanetNNPixelUnit', ...
            'String',' km');
        
        
        % % Y Axis
          uicontrol('Parent',hpanel(3), 'Style','text', ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','center', ...
            'Position',[0.02 0.039 0.042 0.035], ...
            'String','Y Axis:');
        rh3 = uibuttongroup('Parent',hpanel(3), ...
            'BackgroundColor',colo, ...
            'visible','on', ...
            'Position',[0.085 0.033 .13 0.05], ...
            'Units','normalized');  
        set(rh3,'SelectionChangeFcn','gias_guifun_v06 setPlanetNNSizeYLinLog' );
        % Create radio buttons in the button group.
        uicontrol('Style','Radio','String','Linear',...
            'Units','normalized', 'FontSize',10,'BackgroundColor',colo,...
            'pos',[0.03 0.1 0.405 .75],'parent',rh3,'Tag', 'PlanetNNYSizeLinear');
        uicontrol('Style','Radio','String','Log',...
            'Units','normalized','FontSize',10, 'BackgroundColor',colo,...
            'pos',[0.484 0.1 0.495 .75],'parent',rh3,'Tag', 'PlanetNNYSizeLog');
        uicontrol('Parent',hpanel(3), 'Style','text', ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, 'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','center', ...
            'Position',[0.02 0.039 0.062 0.035], ...
            'String','Y Axis:');

        % Maximum Value for the Y Axis
        rh31 = uibuttongroup('Parent',hpanel(3), ...
            'BackgroundColor',colo, ...
            'visible','on', ...
            'Position',[0.22 0.033 .065 0.05], ...
            'Units','normalized');  
        set(rh31,'SelectionChangeFcn','gias_guifun_v06 setPlanetNNYAxisMaxSize' );

        uicontrol('Style','checkbox','String','Custom','Value', 0, ...
            'Units','normalized','FontSize',10, 'BackgroundColor',colo,...
            'pos',[0.05 0.05 0.85 .85],'parent',rh31, 'Tag', 'PlanetNNSizeYAxisMax');
       % Input box for Y axis maximum size
        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'Callback','gias_guifun_v06 setPlanetNNYAxisMaxSize', ...
            'BackgroundColor',[0.3 0.6 0.2], ...
            'FontSize',10, ...
            'ForegroundColor', [1 1 1], ...
            'Position', [0.29 0.035 0.035 0.04], ...
            'String','Max', ...
            'Style','edit', ...
            'Tag','PlanetNNYAxisMaxSizeValue', ...
            'TooltipString','Enter maxiumum frequency');        
%%%%%%%
        % Histogram - bottom left - NearestNeighbour distances
        axes('Parent',hpanel(3), ...
            'Box','on', ...
            'CameraUpVector',[0 1 0], ...
            'CameraUpVectorMode','manual', ...
            'Color',[1 1 1], ...
            'FontSize',8, ...
            'Position',[0.05 0.25 0.3 0.645], ...
            'Tag','Axes16', ...
            'NextPlot','add', ...
            'XColor',[0 0 0], ...
            'XTickMode','manual', ...
            'YColor',[0 0 0], ...
            'YTickMode','manual', ...
            'ZColor',[0 0 0]);

        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, ...
            'FontWeight', 'bold',...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','center', ...
            'Position',[0.07 0.91 0.26 0.035], ...
            'String','Nearest Neigbor Frequency Distribution', ...
            'Style','text', ...
            'TooltipString',' Histogram of Nearest Neighbor Distances');

        % C statistic plot - middle left
        axes('Parent',hpanel(3), ...
            'Box','on', ...
            'CameraUpVector',[0 1 0], ...
            'CameraUpVectorMode','manual', ...
            'Color',[1 1 1], ...
            'FontSize',8, ...
            'Position',[0.382 0.05 0.275 0.40], ...
            'Tag','Axes18', ...
            'NextPlot','add', ...
            'XColor',[0 0 0], ...
            'XTickMode','manual', ...
            'YColor',[0 0 0], ...
            'YTickMode','manual', ...
            'ZColor',[0 0 0]);
 
       uibutton('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor','w', ...
            'FontSize',8, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Interpreter', 'tex',...
            'Position',[0.557 0.1 0.07 0.035], ...
            'String','C Threshold (2 \sigma):', ...
            'Style','text');
        
        uibutton('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor','w', ...
            'FontSize',8, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Interpreter', 'tex',...
            'Position',[0.557 0.369 0.07 0.035], ...
            'String','C Threshold (1 \sigma):', ...
            'Style','text');
        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','center', ...
            'Position',[0.378 0.465 0.08 0.035], ...
            'String','C statistic plot', ...
            'FontWeight', 'bold',...
            'Style','text', ...
            'TooltipString','');
        % Implication box
        uicontrol('Style','text',...
            'Parent',hpanel(3), 'Units','normalized', ...
            'BackgroundColor',colortab, 'FontSize',8, ...
            'ListboxTop',0, 'ForegroundColor',[1 0 0 ], ...
            'HorizontalAlignment','left', ...
            'Position',[0.46 0.46 0.15 0.035], ...
            'Units','normalized', ...
            'String',' ',...
            'Tag','ImplicationCp');
        

        % R statistic plot - middle left
        axes('Parent',hpanel(3), ...
            'Box','on', ...
            'CameraUpVector',[0 1 0], ...
            'CameraUpVectorMode','manual', ...
            'Color',[1 1 1], ...
            'FontSize',8, ...
            'Position',[0.38 0.53 0.275 0.4], ...
            'Tag','Axes17', ...
            'NextPlot','add', ...
            'XColor',[0 0 0], ...
            'XTickMode','manual', ...
            'YColor',[0 0 0], ...
            'YTickMode','manual', ...
            'ZColor',[0 0 0]);
    
        uibutton('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor','w', ...
            'FontSize',8, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.553 0.58 0.073 0.045], ...
            'String','R Threshold (2 \sigma):', ...
            'Interpreter', 'tex',...
            'Style','text');

        
        uicontrol('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor',colortab, ...
            'FontSize',10, ...
            'ListboxTop',0, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','center', ...
            'Position',[0.378 0.94 0.08 0.035], ...
            'String','R statistic plot', ...
            'Style','text', ...
            'FontWeight', 'bold',...
            'Tag','textRstatisticOut', ...
            'TooltipString','');
        % Implication box
        uicontrol('Style','text',...
            'Parent',hpanel(3), 'Units','normalized', ...
            'BackgroundColor',colortab, 'FontSize',8, ...
            'ListboxTop',0, 'ForegroundColor',[1 0 0], ...
            'HorizontalAlignment','left', ...
            'Position',[0.46 0.937 0.15 0.035], ...
            'Units','normalized', ...
            'String',' ',...
            'Tag','ImplicationRp');

        uibutton('Parent',hpanel(3), ...
            'Units','normalized', ...
            'BackgroundColor','w', ...
            'FontSize',8, ...
            'ForegroundColor',[0 0 0], ...
            'HorizontalAlignment','right', ...
            'Position',[0.553 0.847 0.073 0.045], ...
            'String','R Threshold (1 \sigma):', ...
            'Interpreter', 'tex',...
            'Style','text');

        
