function [data] = WriteOutDataStatistics(data)

% Function to save the output of the GIAS programme to an Excel readable
% format sheet

% Author: Ciaran Beggan
% Created: 17-05-2008
% Last Modified: 17-05-2008
%
% Version 0.1: Initial script to output the data in a format similar to the
%               Excel sheet from CWH.


Outputfilename_nn = [data.outfile 'NearestNeighborStats.txt'];


fid1 = fopen(Outputfilename_nn, 'w');

% Headers
fprintf(fid1, '%s \n', 'Geological Image Analysis Software (GIAS)');
fprintf(fid1, '%s \n', 'Nearest Neighbor (NN) Analysis Results');
fprintf(fid1, '\t \n');
fprintf(fid1, '%s \t %s \n', 'Input Image Name: ', data.filename1); 
fprintf(fid1, '%s \t %s \n', 'Date of Analysis: ', date);
fprintf(fid1, '%s \t %d \t %s \n', 'Minimum Object Area: ', data.IgnoreSmallArea*data.PixelSize^2, 'mm^2');
if strcmp(data.IgnoreLargeArea, 'Max')
    fprintf(fid1, '%s \t %d \t %s \n', 'Maximum Object Area: ', max(data.areas)*data.PixelSize^2, 'mm^2');
else
   fprintf(fid1, '%s \t %d \t %s \n', 'Maximum Object Area: ', data.IgnoreLargeArea*data.PixelSize^2, 'mm^2');
end
fprintf(fid1, '%s \t %d \t %s \n', 'Black / White Threshold: ', data.SetThresholdLevel, 'DN');
fprintf(fid1, '%s \t %d \t %s \n', 'Pixel Size: ', data.PixelSize, 'mm');
if data.IgnoreBoundaryBubbles
    fprintf(fid1, '%s \t %s \n', 'Ignore Boundary Bubbles:  ', 'Yes');
else
    fprintf(fid1, '%s \t %s \n', 'Ignore Boundary Bubbles:  ', 'No');
end
fprintf(fid1, '\t \n');

% Statistical Summary for Actual NN Distances
fprintf(fid1, '%s \n', 'Statistical Summary for Actual NN Distances');
fprintf(fid1, '\t \n');
fprintf(fid1, '%s \n', 'Actual NN Distances');
fprintf(fid1, '%s \t %d \n', 'Total Number of Objects ', length(data.allpoints));
fprintf(fid1, '%s \t %d \n', 'Number of Objects in Convex Hull ', data.NN);
fprintf(fid1, '%s \t %d \n', 'Convex Hull Area ', data.chull_area); 
fprintf(fid1, '%s \t %e \n', 'Population Density ', data.rho_0);
fprintf(fid1, '%s \t %f \n', 'Minimum NN Distance ', data.minval);
fprintf(fid1, '%s \t %f \n', 'Maximum NN Distance ', data.maxval);
fprintf(fid1, '%s \t %f \n', 'Mean NN Distance ', data.meanval);
fprintf(fid1, '%s \t %f \n', 'Standard Deviation (1 sigma) ', data.stdval);
fprintf(fid1, '%s \t %f \n', 'Standard Deviation (2 sigma) ', data.stdval*2);
%fprintf(fid1, '%s \t %f \n', 'Modal NN Distance', data.modeval);
fprintf(fid1, '%s \t %f \n', 'Skewness', data.skewval);
fprintf(fid1, '%s \t %f \n', 'Kurtosis', data.kurtval);
fprintf(fid1, '\t \n');

fprintf(fid1, '%s \n', 'Statistical Summary for Expected  NN Distances');
fprintf(fid1, '\t %s \n', data.NNModelSelection);
fprintf(fid1, '%s \t %f \n', 'Expected Mean NN Distance', data.re);
fprintf(fid1, '%s \t %f \n', 'R ', data.r);
fprintf(fid1, '%s \t %f \n', 'Ideal R ', data.idealr);
fprintf(fid1, '%s \t %f \n', 'R Positive Threshold at 1 sigma ', data.rthreshpos1); 
fprintf(fid1, '%s \t %f \n', 'R Positive Threshold at 2 sigma ', data.rthreshpos2);
fprintf(fid1, '%s \t %f \n', 'R Hegative Threshold at 1 sigma ', data.rthreshneg1); 
fprintf(fid1, '%s \t %f \n', 'R Negative Threshold at 2 sigma ', data.rthreshneg2);
fprintf(fid1, '%s \t %f \n', 'C ', data.c);
fprintf(fid1, '%s \t %f \n', 'Ideal C ', data.idealc);
fprintf(fid1, '%s \t %f \n', 'C Positive Threshold at 1 sigma ', data.cthreshpos1); 
fprintf(fid1, '%s \t %f \n', 'C Positive Threshold at 2 sigma ', data.cthreshpos2);
fprintf(fid1, '%s \t %f \n', 'C Hegative Threshold at 1 sigma ', data.cthreshneg1); 
fprintf(fid1, '%s \t %f \n', 'C Negative Threshold at 2 sigma ', data.cthreshneg2);

% Detailed results
fprintf(fid1, '\t \n');
fprintf(fid1, '%s \n', 'Detailed Results');
fprintf(fid1, '\t \n');
fprintf(fid1, '%s \n', 'Objects forming the Convex Hull');
fprintf(fid1, '%s \t %s \t %s \n', 'Object Identification Number', 'Centroid x Coordinate', 'Centroid y Coordinate');
for i = 1:length(data.k)
    fprintf(fid1, '%d \t %d \t %d \n', i, data.allpoints(data.k(i), 1), data.allpoints(data.k(i), 2));
end

fprintf(fid1, '\t \n');
fprintf(fid1, '%s \n', 'Objects within the Convex Hull');
fprintf(fid1, '%s \t %s \t %s \n', 'Object Identification Number', 'Centroid x Coordinate', 'Centroid y Coordinate');

fclose(fid1);