function data = WriteOutNNStatistics(data)

% Function to produce the data for the Nearest Neightbour statistic summary
% for Tab 2

% Author: Ciaran Beggan
% Created: 24-03-2008
% Last Modified: 10-05-2008

% Version 0.1: Initial script produce stats and draw
%              into the relevant boxes
% Version 0.2: Added code to calculate r and c based only on the interior
%               points of the convex hull (i.e. boundary hull points are
%               exluded)


pixsize = data.PixelSize;
stat = data.distances*pixsize;
data.NN = length(stat);
rho_0 = data.NN/(data.chull_area*pixsize^2);

data.rho_0 = rho_0; % For output file

if strcmp(data.NNModelSelection, 'Poisson')
    
    ra = mean(stat);
    re = 1/(2* sqrt(rho_0));
    sde = 0.26136/( sqrt(data.NN*rho_0));

    c = (ra - re)/sde;
    r = ra/re;

elseif strcmp(data.NNModelSelection, 'NormPoisson')
    
    min_rpnn = data.SetNormPoissonThresholdLevel*pixsize;

    ra = mean(stat);
    new_distances = stat(stat>min_rpnn);
    data.NN = length(new_distances);
    
    if isempty(new_distances) % If there are no data (i.e. the threshold is set too high)
        re = 0; sde = 0;
        c = 0; r = 0;
        data.c = 0;
        data.r = 0;
    else
        
        re =  (sum((new_distances.^2).*exp(-pi*rho_0*new_distances.^2)))/sum((new_distances).*exp(-pi*rho_0*new_distances.^2));
        
        vare = (sum((new_distances.^3).*exp(-pi*rho_0*new_distances.^2)))/sum((new_distances).*exp(-pi*rho_0*new_distances.^2)); 

        sde =  sqrt(vare)/sqrt(data.NN);

        c = (ra - re)/sde; data.c = c;
        r = ra/re; data.r = r;
    end

elseif strcmp(data.NNModelSelection, 'ScavangedPoisson')
    ra = mean(stat);
    if (data.setkvalue == 1)
        re = 3/(4*sqrt(rho_0));
        sde = 0.2722249/( sqrt(data.NN*rho_0));
    elseif (data.setkvalue == 2)
        re = 15/(16*sqrt(rho_0));
        sde = 0.27572/( sqrt(data.NN*rho_0));
    end
    c = (ra - re)/sde;
    r = ra/re;
    
% elseif strcmp(data.NNModelSelection, 'Logistic')
%         
%     % Approximate values for b and m
%     ra = mean(stat);
%     [phat] = logifit_gias(stat);
%     re = phat(1);
%     sde = phat(2)*pi/sqrt(3);
%     
%     c = (ra - re)/sde;
%     r = ra/re;
else
    error('Write out Summary Stats: Radio Button Choice Not Found')
end


data.BubOut = data.NN;
data.minval = min(stat); 
data.maxval = max(stat);
data.meanval = mean(stat);
data.stdval = std(stat);
data.modeval = mode(stat);
data.skewval = ( data.NN/ ((data.NN-1)*(data.NN-2)) ) .* sum( ((stat - ra)./std(stat)).^3 );
data.kurtval = (( (data.NN*(data.NN+1)) / ((data.NN-1)*(data.NN-2)*(data.NN-3)) ) * sum( ((stat - ra)./std(stat)).^4 )) - (3*(data.NN-1)^2) / ((data.NN-2)*(data.NN-3));
    
data.NNskew = data.skewval;
data.NNkurt = data.kurtval;

set(findobj(gcbf,'Tag','NNNumBubblesOut'),'String',num2str(data.BubOut, '%6d'));
set(findobj(gcbf,'Tag','NNMinimumOut'),'String',num2str(data.minval, '%10.3f'));
set(findobj(gcbf,'Tag','NNMaximumOut'),'String',num2str(data.maxval, '%10.3f'));
set(findobj(gcbf,'Tag','NNMeanOut'),'String',num2str(data.meanval, '%10.3f'));
set(findobj(gcbf,'Tag','NNStdOut'),'String',num2str(data.stdval, '%10.3f'));
set(findobj(gcbf,'Tag','NNModeOut'),'String',num2str(data.modeval, '%10.3f'));
set(findobj(gcbf,'Tag','NNSkewnessOut'),'String',num2str(data.skewval, '%10.3f'));
set(findobj(gcbf,'Tag','NNKurtosisOut'),'String',num2str(data.kurtval, '%10.3f'));

set(findobj(gcbf,'Tag','NNReOut'),'String',num2str(re, '%10.3f'));
set(findobj(gcbf,'Tag','NNStd_eOut'),'String',num2str(sde, '%10.3f'));
set(findobj(gcbf,'Tag','NNROut'),'String',num2str(r, '%10.3f'));
set(findobj(gcbf,'Tag','NNCOut'),'String',num2str(c, '%10.3f'));



set(gcbf, 'Userdata', data)