function data = WriteOutPlanetNNStatistics(data)

% Function to produce the data for the Nearest Neightbour statistic summary
% for Planetary Tab 3

% Author: Ciaran Beggan
% Created: 19-11-2010
% Last Modified: 20-11-2011


% Version 0.1: Initial script produce stats and draw
%              into the relevant boxes
% Version 0.2: Added code to calculate r and c based only on the interior
%               points of the convex hull (i.e. boundary hull points are
%               exluded)
% Version 0.3: Removed the k=1 and k=2 options. Added a third of a planet
%               options

pixsize = 1; % Pixel size is in km
stat = data.distances*pixsize;

if  strcmp(data.PlanetDatasetSize, 'Whole')
    rho_0 = data.NN/(ellarea(data.PlanetRadius(1),data.PlanetRadius(2)));
elseif strcmp(data.PlanetDatasetSize, 'Half')
    rho_0 = data.NN/(ellarea(data.PlanetRadius(1),data.PlanetRadius(2))/2);
elseif strcmp(data.PlanetDatasetSize, 'Third')
    rho_0 = data.NN/(ellarea(data.PlanetRadius(1),data.PlanetRadius(2))/3);
elseif strcmp(data.PlanetDatasetSize, 'Quarter')
    rho_0 = data.NN/(ellarea(data.PlanetRadius(1),data.PlanetRadius(2))/4);
else
    rho_0 = data.NN/(data.chull_area*pixsize^2);
end


data.rho_0 = rho_0; % For output file

    
    ra = mean(stat);
    re = 1/(2* sqrt(rho_0));
    sde = 0.26136/( sqrt(data.NN*rho_0));

    c = (ra - re)/sde;
    r = ra/re;


data.PlanetBubOut = data.NN;
data.Planetminval = min(stat); 
data.Planetmaxval = max(stat);
data.Planetmeanval = mean(stat);
data.Planetstdval = std(stat);
data.Planetmodeval = mode(stat);
data.skewval = ( data.NN/ ((data.NN-1)*(data.NN-2)) ) .* sum( ((stat - ra)./std(stat)).^3 );
data.kurtval = (( (data.NN*(data.NN+1)) / ((data.NN-1)*(data.NN-2)*(data.NN-3)) ) * sum( ((stat - ra)./std(stat)).^4 )) - (3*(data.NN-1)^2) / ((data.NN-2)*(data.NN-3));
    
data.PlanetNNskew = data.skewval;
data.PlanetNNkurt = data.kurtval;

set(findobj(gcbf,'Tag','PlanetNNNumBubblesOut'),'String',num2str(data.PlanetBubOut, '%6d'));
set(findobj(gcbf,'Tag','PlanetNNMinimumOut'),'String',num2str(data.Planetminval, '%10.3f'));
set(findobj(gcbf,'Tag','PlanetNNMaximumOut'),'String',num2str(data.Planetmaxval, '%10.3f'));
set(findobj(gcbf,'Tag','PlanetNNMeanOut'),'String',num2str(data.Planetmeanval, '%10.3f'));
set(findobj(gcbf,'Tag','PlanetNNStdOut'),'String',num2str(data.Planetstdval, '%10.3f'));
set(findobj(gcbf,'Tag','PlanetNNModeOut'),'String',num2str(data.Planetmodeval, '%10.3f'));
set(findobj(gcbf,'Tag','PlanetNNSkewnessOut'),'String',num2str(data.PlanetNNskew, '%10.3f'));
set(findobj(gcbf,'Tag','PlanetNNKurtosisOut'),'String',num2str(data.PlanetNNkurt, '%10.3f'));

set(findobj(gcbf,'Tag','PlanetNNReOut'),'String',num2str(re, '%10.3f'));
set(findobj(gcbf,'Tag','PlanetNNStd_eOut'),'String',num2str(sde, '%10.3f'));
set(findobj(gcbf,'Tag','PlanetNNROut'),'String',num2str(r, '%10.3f'));
set(findobj(gcbf,'Tag','PlanetNNCOut'),'String',num2str(c, '%10.3f'));



set(gcbf, 'Userdata', data)