function data = WriteOutSummaryStatistic(data)

% Function to produce the data for the statistical summary for Tab 1

% Author: Ciaran Beggan
% Created: 21-03-2008
% Last Modified: 21-03-2008

% Version 0.1: Initial script produce stats and draw
%              into the relevant boxes


if strcmp(data.SummaryStatistics, 'Area')
    stat = data.areas*data.PixelSize^2;
elseif strcmp(data.SummaryStatistics, 'StatPerimeter')
    stat = data.perimeters*data.PixelSize;
elseif strcmp(data.SummaryStatistics, 'StatEccentricity')
    stat = data.eccentricity;
elseif strcmp(data.SummaryStatistics, 'StatOrientation')
    stat = data.orientations;
else
        error('Write out Summary Stats: Radio Button Choice Not Found')
end

BubOut = length(stat);
minval = min(stat); maxval = max(stat); meanval = mean(stat);

stdval = std(stat); modeval = median(stat); skewval =( BubOut/ ((BubOut-1)*(BubOut-2)) ) .* sum( ((stat - mean(stat))./std(stat)).^3 );
kurtval = (( (BubOut*(BubOut+1)) / ((BubOut-1)*(BubOut-2)*(BubOut-3)) ) * sum( ((stat - mean(stat))./std(stat)).^4 )) - (3*(BubOut-1)^2) / ((BubOut-2)*(BubOut-3));


set(findobj(gcbf,'Tag','StatPercentVesiclesOut'),'String',num2str(data.percentvesicle, '%5.2f'));
set(findobj(gcbf,'Tag','StatNumBubblesOut'),'String',num2str(BubOut, '%6d'));
set(findobj(gcbf,'Tag','StatMinimumOut'),'String',num2str(minval, '%9.2f'));
set(findobj(gcbf,'Tag','StatMaximumOut'),'String',num2str(maxval, '%9.2f'));
set(findobj(gcbf,'Tag','StatMeanOut'),'String',num2str(meanval, '%9.2f'));
set(findobj(gcbf,'Tag','StatStdOut'),'String',num2str(stdval, '%9.2f'));
set(findobj(gcbf,'Tag','StatModeOut'),'String',num2str(modeval, '%9.2f'));
set(findobj(gcbf,'Tag','StatSkewnessOut'),'String',num2str(skewval, '%9.2f'));
set(findobj(gcbf,'Tag','StatKurtosisOut'),'String',num2str(kurtval, '%9.2f'));

set(gcbf, 'Userdata', data)