function [data] = WriteOuttoFileIADataStatistics(data)

% Function to save the Image Analysis tab output of the GIAS programme to an Excel readable
% format sheet

% Author: Ciaran Beggan
% Created: 17-05-2008
% Last Modified: 17-05-2008
%
% Version 0.1: Initial script to output the data in a format similar to the
%               Excel sheet from CWH.


Outputfilename_ia = [fullfile(data.pathname_outfile,data.outfile) 'ImageAnalysisStats.txt'];


fid1 = fopen(Outputfilename_ia, 'w');

% Headers
fprintf(fid1, '%s \n', 'Geological Image Analysis Software (GIAS)');
fprintf(fid1, '%s \n', 'Image Analysis (IA) Results');
fprintf(fid1, '\t \n');
fprintf(fid1, '%s \t %s \n', 'Input Image Name: ', data.filename1); 
fprintf(fid1, '%s \t %s \n', 'Date of Analysis: ', date);

xPixelUnit2 = get(findobj(gcbf,'Tag','IAPixelUnit'),'String');
xPixelUnit = get(findobj(gcbf,'Tag','NNPixelUnit'),'String');

fprintf(fid1, '%s \t %5.3f \n', 'Percentage Vesicles ', data.percentvesicle);
fprintf(fid1, '%s \t %d \t %s \n', 'Minimum Object Area: ', data.IgnoreSmallArea*data.PixelSize^2, cell2mat(xPixelUnit2(1)));
if strcmp(data.IgnoreLargeArea, 'Max')
    fprintf(fid1, '%s \t %d \t %s \n', 'Maximum Object Area: ', max(data.areas)*data.PixelSize^2, cell2mat(xPixelUnit2(1)));
else
   fprintf(fid1, '%s \t %d \t %s \n', 'Maximum Object Area: ', data.IgnoreLargeArea*data.PixelSize^2, cell2mat(xPixelUnit2(1)));
end
fprintf(fid1, '%s \t %d \t %s \n', 'Lower B/W Threshold: ', data.SetThresholdLevelLower, 'DN');
fprintf(fid1, '%s \t %d \t %s \n', 'Upper B/W Threshold: ', data.SetThresholdLevelUpper, 'DN');
fprintf(fid1, '%s \t %d \t %s \n', 'Pixel Size: ', data.PixelSize, cell2mat(xPixelUnit(1)));
if data.IgnoreBoundaryBubbles
    fprintf(fid1, '%s \t %s \n', 'Ignore Boundary Bubbles:  ', 'Yes');
else
    fprintf(fid1, '%s \t %s \n', 'Ignore Boundary Bubbles:  ', 'No');
end
fprintf(fid1, '\t \n');
 
% Statistical Summary for Actual NN Distances
fprintf(fid1, '%s \n', 'Statistical Summary');
fprintf(fid1, '\t \n');
fprintf(fid1, '%s \t %d \n', 'Total Number of Objects ', length(data.allpoints));

fprintf(fid1, ' \t %s \t %s \t %s \t %s \t %s \t %s \t %s \n', 'Minimum', 'Maximum',	'Mean',	...
    'Standard Deviation (1 sigma)', 'Mode', 'Skewness', 'Kurtosis');
stat = data.areas;
fprintf(fid1, '%s \t %f \t %f \t %f \t %f \t %f \t %f \t %f \n', 'Object Area', ...
    min(stat), max(stat), mean(stat), ...
    std(stat), mode(stat), skewness(stat),kurtosis(stat));

stat = data.equiv_diameters/2;
fprintf(fid1, '%s \t %f \t %f \t %f \t %f \t %f \t %f \t %f \t \n', 'Radius', ...
    min(stat), max(stat), mean(stat), ...
    std(stat), mode(stat), skewness(stat),kurtosis(stat));

stat = data.perimeters;
fprintf(fid1, '%s \t %f \t %f \t %f \t %f \t %f \t %f \t %f \t \n', 'Perimeters', ...
    min(stat), max(stat), mean(stat), ...
    std(stat), mode(stat), skewness(stat),kurtosis(stat));

stat = data.eccentricity;
fprintf(fid1, '%s \t %f \t %f \t %f \t %f \t %f \t %f \t %f \t \n', 'Eccentricity', ...
    min(stat), max(stat), mean(stat), ...
    std(stat), mode(stat), skewness(stat),kurtosis(stat));

stat = data.orientations;
fprintf(fid1, '%s \t %f \t %f \t %f \t %f \t %f \t %f \t %f \t \n', 'Orientations', ...
    min(stat), max(stat), mean(stat), ...
    std(stat), mode(stat), skewness(stat),kurtosis(stat));

% Detailed results
 fprintf(fid1, '\t \n');
 fprintf(fid1, '%s \n', 'Detailed Results');
 fprintf(fid1, '\t \n');
 fprintf(fid1, '%s \t %s \t %s \t %s \t %s \t %s \t %s \t %s \n', ...
     'Object Identification Number', 'Centroid x Coordinate', 'Centroid y Coordinate', ...
     'Area', 'Eq. Area Circle Radius', 'Perimeter', 'Eccentricity',	'Orientation');
 for i = 1:length(data.allpoints)
     fprintf(fid1, '%d \t %f \t %f \t %f \t %f \t %f \t %f \t %f \n', i, ..., 
         data.allpoints(i, 1), data.allpoints(i, 2), ...
         data.areas(i)*data.PixelSize^2, (data.equiv_diameters(i)/2)*data.PixelSize, data.perimeters(i)*data.PixelSize, ...
         data.eccentricity(i), data.orientations(i));
 end
     

fclose(fid1);