function [data] = WriteOuttoFileNNDataStatistics(data)

% Function to save the Nearest Neighbor output of the GIAS programme to an Excel readable
% format sheet

% Author: Ciaran Beggan
% Created: 17-05-2008
% Last Modified: 01-09-2009
%
% Version 0.1: Initial script to output the data in a format similar to the
%               Excel sheet from CWH.
% Version 0.2: Removed all references to the Logistic test.


Outputfilename_nn = [ fullfile(data.pathname_outfile,data.outfile) 'NearestNeighborStats.txt'];


fid1 = fopen(Outputfilename_nn, 'w');

% Headers
fprintf(fid1, '%s \n', 'Geological Image Analysis Software (GIAS)');
fprintf(fid1, '%s \n', 'Nearest Neighbor (NN) Analysis Results');
fprintf(fid1, '\t \n');
fprintf(fid1, '%s \t %s \n', 'Input Image Name: ', data.filename1); 
fprintf(fid1, '%s \t %s \n', 'Date of Analysis: ', date);

xPixelUnit2 = get(findobj(gcbf,'Tag','IAPixelUnit'),'String');
xPixelUnit = get(findobj(gcbf,'Tag','NNPixelUnit'),'String');

fprintf(fid1, '%s \t %d \t %s \n', 'Minimum Object Area: ', data.IgnoreSmallArea*data.PixelSize^2, cell2mat(xPixelUnit2(1)));
if strcmp(data.IgnoreLargeArea, 'Max')
    fprintf(fid1, '%s \t %d \t %s \n', 'Maximum Object Area: ', max(data.areas)*data.PixelSize^2, cell2mat(xPixelUnit2(1)));
else
   fprintf(fid1, '%s \t %d \t %s \n', 'Maximum Object Area: ', data.IgnoreLargeArea*data.PixelSize^2, cell2mat(xPixelUnit2(1)));
end
fprintf(fid1, '%s \t %d \t %s \n', 'Lower B/W Threshold: ', data.SetThresholdLevelLower, 'DN');
fprintf(fid1, '%s \t %d \t %s \n', 'Upper B/W Threshold: ', data.SetThresholdLevelUpper, 'DN');
fprintf(fid1, '%s \t %d \t %s \n', 'Pixel Size: ', data.PixelSize, cell2mat(xPixelUnit(1)));
if data.IgnoreBoundaryBubbles
    fprintf(fid1, '%s \t %s \n', 'Ignore Boundary Bubbles:  ', 'Yes');
else
    fprintf(fid1, '%s \t %s \n', 'Ignore Boundary Bubbles:  ', 'No');
end
fprintf(fid1, '\t \n');

% Statistical Summary for Actual NN Distances
fprintf(fid1, '%s \n', 'Statistical Summary for Actual NN Distances');
fprintf(fid1, '\t \n');
fprintf(fid1, '%s \n', 'Actual NN Distances');
fprintf(fid1, '%s \t %d \n', 'Total Number of Objects ', length(data.allpoints));
fprintf(fid1, '%s \t %d \n', 'Number of Objects in Convex Hull ', data.NN);
fprintf(fid1, '%s \t %d \n', 'Convex Hull Area (Pixels)', data.chull_area); 
fprintf(fid1, '%s \t %e \n', 'Population Density (num/unit area)', data.rho_0);
fprintf(fid1, '%s \t %f \n', 'Minimum NN Distance (unit distance)', data.minval);
fprintf(fid1, '%s \t %f \n', 'Maximum NN Distance (unit distance)', data.maxval);
fprintf(fid1, '%s \t %f \n', 'Mean NN Distance (unit distance)', data.meanval);
fprintf(fid1, '%s \t %f \n', 'Standard Deviation (1 sigma) ', data.stdval);
fprintf(fid1, '%s \t %f \n', 'Standard Deviation (2 sigma) ', data.stdval*2);
fprintf(fid1, '%s \t %f \n', 'Skewness', data.skewval);
fprintf(fid1, '%s \t %f \n', 'Kurtosis', data.kurtval);
fprintf(fid1, '\t \n');


[output_statsPNN, output_statsNPNN, output_statsK1NN, output_statsK2NN] = CalculatePNSLstats(data);

fprintf(fid1, '%s \n \n', 'Statistical Summary for Expected  NN Distances');
fprintf(fid1, '\t %s \t %s \t %s \t %s  \n', 'Poisson (Random)',	'Normalized Poisson', 'Scavanged (k = 1)', 'Scavanged (k = 2)');
fprintf(fid1, '%s \t %f \t %f \t %f \t %f \n', 'Expected Mean NN Distance', output_statsPNN.re, output_statsNPNN.re, output_statsK1NN.re, output_statsK2NN.re);
fprintf(fid1, '%s \t %f \t %f \t %f \t %f  \n', 'R ', output_statsPNN.r, output_statsNPNN.r, output_statsK1NN.r, output_statsK2NN.r);
fprintf(fid1, '%s \t %f \t %f \t %f \t %f  \n', 'Ideal R ', output_statsPNN.idealr, output_statsNPNN.idealr, output_statsK1NN.idealr, output_statsK2NN.idealr);
fprintf(fid1, '%s \t %f \t %f \t %f \t %f  \n', 'R Positive Threshold at 1 sigma ', output_statsPNN.rthreshpos1, output_statsNPNN.rthreshpos1, output_statsK1NN.rthreshpos1, output_statsK2NN.rthreshpos1); 
fprintf(fid1, '%s \t %f \t %f \t %f \t %f  \n', 'R Positive Threshold at 2 sigma ', output_statsPNN.rthreshpos2, output_statsNPNN.rthreshpos2, output_statsK1NN.rthreshpos2, output_statsK2NN.rthreshpos2);
fprintf(fid1, '%s \t %f \t %f \t %f \t %f  \n', 'R Hegative Threshold at 1 sigma ', output_statsPNN.rthreshneg1, output_statsNPNN.rthreshneg1, output_statsK1NN.rthreshneg1, output_statsK2NN.rthreshneg1); 
fprintf(fid1, '%s \t %s \t %s \t %s \t %s  \n', 'Implication ', output_statsPNN.ImplicationR, output_statsNPNN.ImplicationR, output_statsK1NN.ImplicationR, output_statsK2NN.ImplicationR);

fprintf(fid1, '%s \t %f \t %f \t %f \t %f  \n', 'R Negative Threshold at 2 sigma ', output_statsPNN.rthreshneg2,output_statsNPNN.rthreshneg2, output_statsK1NN.rthreshneg2, output_statsK2NN.rthreshneg2);
fprintf(fid1, '%s \t %f \t %f \t %f \t %f  \n', 'C ', output_statsPNN.c, output_statsNPNN.c, output_statsK1NN.c, output_statsK2NN.c);
fprintf(fid1, '%s \t %f \t %f \t %f \t %f  \n', 'Ideal C ', output_statsPNN.idealc, output_statsNPNN.idealc, output_statsK1NN.idealc, output_statsK2NN.idealc);
fprintf(fid1, '%s \t %f \t %f \t %f \t %f  \n', 'C Positive Threshold at 1 sigma ', output_statsPNN.cthreshpos1, output_statsNPNN.cthreshpos1, output_statsK1NN.cthreshpos1, output_statsK2NN.cthreshpos1); 
fprintf(fid1, '%s \t %f \t %f \t %f \t %f  \n', 'C Positive Threshold at 2 sigma ', output_statsPNN.cthreshpos2, output_statsNPNN.cthreshpos2, output_statsK1NN.cthreshpos2, output_statsK2NN.cthreshpos2);
fprintf(fid1, '%s \t %f \t %f \t %f \t %f  \n', 'C Hegative Threshold at 1 sigma ', output_statsPNN.cthreshneg1, output_statsNPNN.cthreshneg1, output_statsK1NN.cthreshneg1, output_statsK2NN.cthreshneg1); 
fprintf(fid1, '%s \t %f \t %f \t %f \t %f  \n', 'C Negative Threshold at 2 sigma ', output_statsPNN.cthreshneg2, output_statsNPNN.cthreshneg2, output_statsK1NN.cthreshneg2, output_statsK2NN.cthreshneg2);
fprintf(fid1, '%s \t %s \t %s \t %s \t %s  \n', 'Implication ', output_statsPNN.ImplicationC, output_statsNPNN.ImplicationC, output_statsK1NN.ImplicationC, output_statsK2NN.ImplicationC);

% Detailed results
fprintf(fid1, '\t \n');
fprintf(fid1, '%s \n', 'Detailed Results');
fprintf(fid1, '\t \n');
fprintf(fid1, '%s \n', 'Objects forming the Convex Hull');
fprintf(fid1, '%s \t %s \t %s \n', 'Object Identification Number', 'Centroid x Coordinate', 'Centroid y Coordinate');
for i = 1:length(data.k)
    fprintf(fid1, '%d \t %d \t %d \n', i, data.allpoints(data.k(i), 1), data.allpoints(data.k(i), 2));
end

fprintf(fid1, '\t \n');
fprintf(fid1, '%s \n', 'Objects within the Convex Hull');
fprintf(fid1, '%s \t %s \t %s \t %s \t %s \n', 'Object Identification Number', 'Centroid x Coordinate', 'Centroid y Coordinate', 'Nearest Neightbor Distance', 'Nearest Neightbor Object ID Number');
inpoints = data.allpoints;
inpoints(data.k,:) = [];
for i = 1:length(inpoints)
    fprintf(fid1, '%d \t %f \t %f \t %f \t %d \n ', i, inpoints(i, 1), inpoints(i, 2), data.distances(i), data.NNoid(i) );
end
    

fclose(fid1);

% Save images of R and c
 data = SaveNNRandCgraphs(data);
