function [data] = WriteOuttoFilePlanetNNDataStatistics(data)

% Function to save the Nearest Neighbor output of the GIAS programme to an Excel readable
% format sheet

% Author: Ciaran Beggan
% Created: 21-11-2010
% Last Modified: 21-11-2010
%
% Version 0.1: Initial script to output the data in a format similar to the
%               Excel sheet from CWH.
% Version 0.2: Removed all references to the Logistic test.
%              There are no Poisson Normalised,  Scavanged k = 1 or k = 2 because these
%               tests are covered in the NN Tab 2 settings.
% Version 0.3: Output the images to jpeg files and also the implication to
%               the .dat file

Outputfilename_nn = [fullfile(data.pathname_outfile,data.outfile) 'PlanetNearestNeighborStats.txt'];


fid1 = fopen(Outputfilename_nn, 'w');

% Headers
fprintf(fid1, '%s \n', 'Geological Image Analysis Software (GIAS)');
fprintf(fid1, '%s \n', 'Nearest Neighbor (NN) Analysis Results');
fprintf(fid1, '\t \n');
fprintf(fid1, '%s \t %s \n', 'Input Image Name: ', data.filename1); 
fprintf(fid1, '%s \t %s \n', 'Date of Analysis: ', date);


if data.IgnoreBoundaryBubbles
    fprintf(fid1, '%s \t %s \n', 'Ignore Boundary Points:  ', 'Yes');
else
    fprintf(fid1, '%s \t %s \n', 'Ignore Boundary Points:  ', 'No');
end
fprintf(fid1, '\t \n');

% Statistical Summary for Actual NN Distances
fprintf(fid1, '%s \n', 'Statistical Summary for Actual NN Distances');
fprintf(fid1, '\t \n');
fprintf(fid1, '%s \n', 'Actual NN Distances');
fprintf(fid1, '%s \t %s \n', 'Assumed Dataset Size (Planet)', data.PlanetDatasetSize) ;
fprintf(fid1, '%s \t %d \n', 'Total Number of Objects ', length(data.allpoints));
fprintf(fid1, '%s \t %d \n', 'Number of Objects in Convex Hull ', data.NN);
% Hull/Planet area
if  strcmp(data.PlanetDatasetSize, 'Whole')
    area = (ellarea(data.PlanetRadius(1),data.PlanetRadius(2)));
    fprintf(fid1, '%s \t %d \n', 'Calculated Ellipsoidal Area (km^2)', area); 
elseif strcmp(data.PlanetDatasetSize, 'Half')
    area = (ellarea(data.PlanetRadius(1),data.PlanetRadius(2))/2);
    fprintf(fid1, '%s \t %d \n', 'Calculated Ellipsoidal Area (km^2)', area); 
elseif strcmp(data.PlanetDatasetSize, 'Third')
    area = (ellarea(data.PlanetRadius(1),data.PlanetRadius(2))/3);
    fprintf(fid1, '%s \t %d \n', 'Calculated Ellipsoidal Area (km^2)', area); 
elseif strcmp(data.PlanetDatasetSize, 'Quarter')
    area = (ellarea(data.PlanetRadius(1),data.PlanetRadius(2))/4);
    fprintf(fid1, '%s \t %d \n', 'Calculated Ellipsoidal Area (km^2)', area); 
else
    fprintf(fid1, '%s \t %d \n', 'Convex Hull area (km^2)', data.chull_area); 
end

fprintf(fid1, '%s \t %e \n', 'Population Density (num/km^2)', data.rho_0);
fprintf(fid1, '%s \t %f \n', 'Minimum NN Distance (km)', data.Planetminval);
fprintf(fid1, '%s \t %f \n', 'Maximum NN Distance (km)', data.Planetmaxval);
fprintf(fid1, '%s \t %f \n', 'Mean NN Distance (km)', data.Planetmeanval);
fprintf(fid1, '%s \t %f \n', 'Standard Deviation (1 sigma) ', data.Planetstdval);
fprintf(fid1, '%s \t %f \n', 'Standard Deviation (2 sigma) ', data.Planetstdval*2);
fprintf(fid1, '%s \t %f \n', 'Skewness', data.PlanetNNskew);
fprintf(fid1, '%s \t %f \n', 'Kurtosis', data.PlanetNNkurt);
fprintf(fid1, '\t \n');


[output_statsPNN] = CalculatePlanetPNSLstats(data);

fprintf(fid1, '%s \n \n', 'Statistical Summary for Expected  NN Distances');
fprintf(fid1, '\t %s    \n', 'Poisson (Random)');
fprintf(fid1, '%s \t %f  \n', 'Expected Mean NN Distance', output_statsPNN.re);
fprintf(fid1, '%s \t %f   \n', 'R ', output_statsPNN.r);
fprintf(fid1, '%s \t %f   \n', 'Ideal R ', output_statsPNN.idealr);
fprintf(fid1, '%s \t %f   \n', 'R Positive Threshold at 1 sigma ', output_statsPNN.rthreshpos1); 
fprintf(fid1, '%s \t %f   \n', 'R Positive Threshold at 2 sigma ', output_statsPNN.rthreshpos2);
fprintf(fid1, '%s \t %f   \n', 'R Hegative Threshold at 1 sigma ', output_statsPNN.rthreshneg1); 
fprintf(fid1, '%s \t %f   \n', 'R Negative Threshold at 2 sigma ', output_statsPNN.rthreshneg2);
fprintf(fid1, '%s \t %s   \n', 'Implication ', output_statsPNN.ImplicationR);

fprintf(fid1, '%s \t %f   \n', 'C ', output_statsPNN.c);
fprintf(fid1, '%s \t %f   \n', 'Ideal C ', output_statsPNN.idealc);
fprintf(fid1, '%s \t %f   \n', 'C Positive Threshold at 1 sigma ', output_statsPNN.cthreshpos1); 
fprintf(fid1, '%s \t %f   \n', 'C Positive Threshold at 2 sigma ', output_statsPNN.cthreshpos2);
fprintf(fid1, '%s \t %f   \n', 'C Hegative Threshold at 1 sigma ', output_statsPNN.cthreshneg1); 
fprintf(fid1, '%s \t %f   \n', 'C Negative Threshold at 2 sigma ', output_statsPNN.cthreshneg2);
fprintf(fid1, '%s \t %s   \n', 'Implication ', output_statsPNN.ImplicationC);

% Detailed results
fprintf(fid1, '\t \n');
fprintf(fid1, '%s \n', 'Detailed Results');
fprintf(fid1, '\t \n');
if data.IgnoreBoundaryBubbles
    fprintf(fid1, '%s \n', 'Objects forming the Convex Hull');
    fprintf(fid1, '%s \t %s \t %s \n', 'Object Identification Number', 'Centroid x Coordinate', 'Centroid y Coordinate');
    for i = 1:length(data.k)
        fprintf(fid1, '%d \t %d \t %d \n', i, data.allpoints(data.k(i), 1), data.allpoints(data.k(i), 2));
    end

    fprintf(fid1, '\t \n');
    fprintf(fid1, '%s \n', 'Objects within the Convex Hull');
    fprintf(fid1, '%s \t %s \t %s \t %s \t %s \n', 'Object Identification Number', 'Centroid x Coordinate', 'Centroid y Coordinate', 'Nearest Neightbor Distance', 'Nearest Neightbor Object ID Number');
    inpoints = data.allpoints;
    inpoints(data.k,:) = [];
    for i = 1:length(inpoints)
        fprintf(fid1, '%d \t %f \t %f \t %f \t %d \n ', i, inpoints(i, 1), inpoints(i, 2), data.distances(i), data.PlanetNNoid(i) );
    end

else
    fprintf(fid1, '%s \t %s \t %s \t %s \t %s \n', 'Object Identification Number', 'Centroid x Coordinate', 'Centroid y Coordinate', 'Nearest Neightbor Distance', 'Nearest Neightbor Object ID Number');
    inpoints = data.allpoints;
    for i = 1:length(inpoints)
        fprintf(fid1, '%d \t %f \t %f \t %f \t %d \n ', i, inpoints(i, 1), inpoints(i, 2), data.distances(i), data.PlanetNNoid(i) );
    end
    
end
fclose(fid1);

% Save screenshots of the R and c images
SavePlanetNNRandCgraphs(data);
