function [area] = ellarea(a,c)

% Function to compute the surface area of a prolate ellipsiod such
% as a planet or moon. 
%
% This function is based on the formula from the Wikipedia page,
% http://en.wikipedia.org/wiki/Ellipsoid#Surface_area
%
% For a oblate ellipsoid (i.e. a smartie shape - flattened)
% Triaxial dimensions are: a = b > c
% Uses incomplete elliptical integral functions of the first and second
% kind.

% Date started: 01-05-2010
% Date last modified: 05-02-2011
% Author: Ciaran Beggan

if a == c
    area = 4*pi*a^2;
    return
end

b = a;

u = acos(c/a);
m = 1; 
[F,E] = elliptic12(u,m);

area = 2*pi * (c^2 + b * sqrt(a^2 - c^2)*E + (b*c^2)/sqrt(a^2 - c^2) * F );