function [s] = vincenty(lon1lat1,lon2lat2)

% Function to compute the geographic distance on a prolate ellipsiod such
% as a planet or moon. This computes the distance accurately - not that it
% makes much difference in most cases, as the location of the points of interest is
% generally relatively poorly known.
%
% This function is based on the formula from the Wikipedia page, verified
% against the Geoscience Australia website calculator
%
% Date started: 01-05-2010
% Date Last modified: 18-11-2010 
%
% Author: Ciaran Beggan
a = lon1lat1(3); b = lon1lat1(4);
 f = (a-b)/a;
 
 u1 = atan((1-f)*tan(deg2rad(lon1lat1(:,2))));
 u2 = atan((1-f)*tan(deg2rad(lon2lat2(:,2))));
 
 L = deg2rad(lon1lat1(:,1) - lon2lat2(:,1));
 
 lambda = L; converge = 0; iter = 0;
 
 % Iterative search for lambda
 while ~converge && (iter <= 20)
    sinsig = sqrt((cos(u2).*sin(lambda)).^2 + (cos(u1).*sin(u2) - sin(u1).*cos(u2).*cos(lambda)).^2) ;
    cossig = sin(u1).*sin(u2) + cos(u1).*cos(u2).*cos(lambda);
    sig = atan2(sinsig, cossig);
    
    sinalpha = (cos(u1).*cos(u2).*sin(lambda))./sinsig;
    cossqalpha = 1 - sinalpha.^2;
    cos2sigm = cossig - (2.*sin(u1).*sin(u2))./cossqalpha;
    
    C = (f/16) * cossqalpha.*(4 + f*(4-3*cossqalpha));
    
    calclambda = L + (1-C) .* f .* sinalpha .* ...
        (sig + C.*sinalpha.*(cos2sigm + C .* cossig.*(-1 + 2.* cos2sigm) ));
    
    if (abs(lambda - calclambda) < 10^-12)
        converge = 1;
        lambda = calclambda;
    else
        iter = iter + 1;
        lambda = calclambda;
    end
    
 end
 
 usq = cossqalpha * ((a^2 - b^2)/b^2);
 
 A = 1 + usq/16384 .* (4096 + usq.*(-768 + usq.*(320 - 175.*usq)));
 
 B = usq/1024 .* (256 + usq.*(-128 + usq.*(74 - 47.*usq))); 
 
 delsig = B .* sinsig .* (cos2sigm + 0.25 .* B .*(cossig .*(-1 + 2.*cos2sigm) ...
     -(1/6).*B .* cos2sigm.*(-3 + 4.*sinalpha.^2).*(-3+4.*cos2sigm.^2)   ));
 
 s = b.*A.*(sig - delsig);
 